/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data;

import com.mojang.brigadier.StringReader;
import iskallia.vault.VaultMod;
import iskallia.vault.core.world.data.PartialNBT;
import iskallia.vault.core.world.data.PartialState;
import iskallia.vault.core.world.data.PartialTile;
import iskallia.vault.core.world.data.TileParser;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

@FunctionalInterface
public interface TilePredicate
extends Predicate<PartialTile> {
    public boolean test(PartialState var1, PartialNBT var2);

    @Override
    default public boolean test(PartialTile tile) {
        return this.test(tile.getState(), tile.getNbt());
    }

    public static TilePredicate all() {
        return (state, nbt) -> true;
    }

    public static TilePredicate of(String target) {
        TileParser parser = new TileParser(new StringReader(target), null, true);
        if (parser.hasTag()) {
            return parser.hasNBT() ? TilePredicate.of(parser.getTag(), parser.getPartialNBT()) : TilePredicate.of(parser.getTag());
        }
        if (parser.hasBlock()) {
            return parser.hasNBT() ? TilePredicate.of(parser.getPartialState(), parser.getPartialNBT()) : TilePredicate.of(parser.getPartialState());
        }
        VaultMod.LOGGER.error("Unknown predicate for input <" + target + ">");
        return (state, nbt) -> false;
    }

    public static TilePredicate of(TagKey<Block> tag) {
        return (_state, _nbt) -> _state.getBlock().m_204297_().m_203656_(tag);
    }

    public static TilePredicate of(TagKey<Block> tag, PartialNBT nbt) {
        return (_state, _nbt) -> _state.getBlock().m_204297_().m_203656_(tag) && nbt.isSubsetOf(_nbt);
    }

    public static TilePredicate of(Block block) {
        return (_state, _nbt) -> _state.getBlock() == block;
    }

    public static TilePredicate of(Block block, PartialNBT nbt) {
        return (_state, _nbt) -> _state.getBlock() == block && nbt.isSubsetOf(_nbt);
    }

    public static TilePredicate of(BlockState state) {
        return (_state, _nbt) -> _state.matches(state);
    }

    public static TilePredicate of(BlockState state, PartialNBT nbt) {
        return (_state, _nbt) -> _state.matches(state) && nbt.isSubsetOf(_nbt);
    }

    public static TilePredicate of(PartialState state) {
        return (_state, _nbt) -> state.isSubsetOf(_state);
    }

    public static TilePredicate of(PartialState state, PartialNBT nbt) {
        return (_state, _nbt) -> state.isSubsetOf(_state) && nbt.isSubsetOf(_nbt);
    }
}

