/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data;

import iskallia.vault.core.world.data.PartialNBT;
import iskallia.vault.core.world.data.PartialState;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PartialTile {
    protected PartialState state;
    protected PartialNBT nbt;
    protected BlockPos pos;

    protected PartialTile(PartialState state, PartialNBT nbt, BlockPos pos) {
        this.state = state;
        this.nbt = nbt;
        this.pos = pos;
    }

    public PartialState getState() {
        return this.state;
    }

    public PartialNBT getNbt() {
        return this.nbt;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public PartialTile setState(PartialState state) {
        this.state = state;
        return this;
    }

    public PartialTile setNbt(PartialNBT nbt) {
        this.nbt = nbt;
        return this;
    }

    public PartialTile setPos(BlockPos pos) {
        this.pos = pos;
        return this;
    }

    public static PartialTile of(Block block) {
        return PartialTile.of(block, (CompoundTag)PartialNBT.EMPTY);
    }

    public static PartialTile of(BlockState state) {
        return PartialTile.of(state, (CompoundTag)PartialNBT.EMPTY);
    }

    public static PartialTile of(PartialState state) {
        return PartialTile.of(state, (CompoundTag)PartialNBT.EMPTY);
    }

    public static PartialTile of(Block block, CompoundTag nbt) {
        return PartialTile.of(PartialState.of(block), nbt);
    }

    public static PartialTile of(BlockState block, CompoundTag nbt) {
        return PartialTile.of(PartialState.of(block), nbt);
    }

    public static PartialTile of(PartialState state, CompoundTag nbt) {
        return new PartialTile(state, PartialNBT.of(nbt), null);
    }

    public static PartialTile at(Level world, BlockPos pos) {
        return new PartialTile(PartialState.of(world.m_8055_(pos)), PartialNBT.of(world.m_7702_(pos)), pos);
    }

    public PartialTile fillMissing(PartialTile tile) {
        this.fillMissing(tile.state, tile.nbt, tile.pos);
        return this;
    }

    public PartialTile fillMissing(PartialState state, CompoundTag nbt, BlockPos pos) {
        if (this.state != null) {
            this.state.fillMissing(state);
        }
        if (this.nbt != null) {
            this.nbt.fillMissing(nbt);
        }
        if (this.pos == null) {
            this.pos = pos;
        }
        return this;
    }

    public PartialTile copyInto(PartialTile target) {
        if (this.state != null) {
            if (target.getState() == null) {
                target.state = this.state.copy();
            } else {
                this.state.copyInto(target.getState());
            }
        }
        if (this.nbt != null) {
            if (target.getNbt() == null) {
                target.nbt = PartialNBT.of(this.nbt.m_6426_());
            } else {
                this.nbt.copyInto(target.getNbt());
            }
        }
        return null;
    }

    public Tag toNBT(CompoundTag nbt) {
        if (this.pos != null) {
            ListTag posNBT = new ListTag();
            posNBT.add((Object)IntTag.m_128679_((int)this.pos.m_123341_()));
            posNBT.add((Object)IntTag.m_128679_((int)this.pos.m_123342_()));
            posNBT.add((Object)IntTag.m_128679_((int)this.pos.m_123343_()));
            nbt.m_128365_("pos", (Tag)posNBT);
        }
        if (this.state != null) {
            nbt.m_128365_("state", this.state.toNBT(new CompoundTag()));
        }
        if (this.nbt != null) {
            nbt.m_128365_("nbt", (Tag)this.nbt.m_6426_());
        }
        return nbt;
    }

    public Tag toPaletteNBT(CompoundTag nbt, int index) {
        if (this.pos != null) {
            ListTag posNBT = new ListTag();
            posNBT.add((Object)IntTag.m_128679_((int)this.pos.m_123341_()));
            posNBT.add((Object)IntTag.m_128679_((int)this.pos.m_123342_()));
            posNBT.add((Object)IntTag.m_128679_((int)this.pos.m_123343_()));
            nbt.m_128365_("pos", (Tag)posNBT);
        }
        nbt.m_128405_("state", index);
        if (this.nbt != null) {
            nbt.m_128365_("nbt", (Tag)this.nbt.m_6426_());
        }
        return nbt;
    }

    public static PartialTile fromNBT(CompoundTag tag) {
        PartialState state = null;
        PartialNBT nbt = null;
        BlockPos pos = null;
        if (tag.m_128425_("state", 10)) {
            state = PartialState.fromNBT(tag.m_128469_("state"));
        }
        if (tag.m_128425_("pos", 9)) {
            ListTag posNBT = tag.m_128437_("pos", 3);
            pos = new BlockPos(posNBT.m_128763_(0), posNBT.m_128763_(1), posNBT.m_128763_(2));
        }
        if (tag.m_128425_("nbt", 10)) {
            nbt = PartialNBT.of(tag.m_128469_("nbt"));
        }
        return new PartialTile(state, nbt, pos);
    }

    public static PartialTile fromPaletteNBT(CompoundTag tag, Function<Integer, PartialState> stateFunction) {
        PartialState state = null;
        PartialNBT nbt = null;
        BlockPos pos = null;
        if (tag.m_128425_("state", 3)) {
            state = stateFunction.apply(tag.m_128451_("state"));
        }
        if (tag.m_128425_("pos", 9)) {
            ListTag posNBT = tag.m_128437_("pos", 3);
            pos = new BlockPos(posNBT.m_128763_(0), posNBT.m_128763_(1), posNBT.m_128763_(2));
        }
        if (tag.m_128425_("nbt", 10)) {
            nbt = PartialNBT.of(tag.m_128469_("nbt"));
        }
        return new PartialTile(state, nbt, pos);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.state.getBlock()).toString());
        if (!this.state.getProperties().isEmpty()) {
            sb.append('[');
            boolean isNotFirst = false;
            for (Map.Entry<Property<?>, Comparable<?>> entry : this.state.getProperties().entrySet()) {
                if (isNotFirst) {
                    sb.append(',');
                }
                sb.append(entry.getKey().m_61708_());
                sb.append('=');
                sb.append(entry.getKey().m_6940_(entry.getValue()));
                isNotFirst = true;
            }
            sb.append(']');
        }
        if (this.nbt != null) {
            sb.append((Object)this.nbt);
        }
        return sb.toString();
    }

    public PartialTile copy() {
        return new PartialTile(this.state == null ? null : this.state.copy(), this.nbt == null ? null : PartialNBT.of(this.nbt.m_6426_()), this.pos);
    }
}

