/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data;

import com.mojang.brigadier.StringReader;
import iskallia.vault.VaultMod;
import iskallia.vault.core.world.data.TileParser;
import iskallia.vault.init.ModBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PartialState {
    private Block block;
    private final Map<Property<?>, Comparable<?>> properties = new HashMap();

    protected PartialState(Block block) {
        this.block = block;
    }

    protected PartialState(Block block, Map<Property<?>, Comparable<?>> properties) {
        this.block = block;
        this.properties.putAll(properties);
    }

    public static PartialState of(Block block) {
        return new PartialState(block);
    }

    public static PartialState of(BlockState delegate) {
        PartialState state = new PartialState(delegate.m_60734_());
        state.properties.putAll((Map<Property<?>, Comparable<?>>)delegate.m_61148_());
        return state;
    }

    public static PartialState parse(String target) {
        return new TileParser(new StringReader(target), ModBlocks.ERROR_BLOCK, false).parse().getPartialState();
    }

    public Block getBlock() {
        return this.block;
    }

    public Map<Property<?>, Comparable<?>> getProperties() {
        return this.properties;
    }

    public <T extends Comparable<T>> T get(Property<T> property) {
        return (T)this.properties.get(property);
    }

    public <T extends Comparable<T>, V extends T> PartialState with(Property<T> property, V value) {
        this.properties.put(property, (Comparable<?>)value);
        return this;
    }

    public boolean matches(BlockState state) {
        if (state.m_60734_() != this.block || this.properties.size() != state.m_61147_().size()) {
            return false;
        }
        for (Property property : state.m_61147_()) {
            if (!this.properties.containsKey(property)) {
                return false;
            }
            if (this.properties.get(property).equals(state.m_61143_(property))) continue;
            return false;
        }
        return true;
    }

    public boolean isSubsetOf(PartialState state) {
        if (state.getBlock() != this.block) {
            return false;
        }
        for (Map.Entry<Property<?>, Comparable<?>> entry : state.getProperties().entrySet()) {
            Property<?> property = entry.getKey();
            Comparable<?> value = entry.getValue();
            if (!this.properties.containsKey(property) || this.properties.get(property).equals(value)) continue;
            return false;
        }
        return true;
    }

    public void fillMissing(PartialState state) {
        for (Map.Entry<Property<?>, Comparable<?>> entry : state.getProperties().entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }

    public void copyInto(PartialState target) {
        if (this.block != null) {
            target.block = this.block;
        }
        target.properties.putAll(this.properties);
    }

    public BlockState asBlockState() {
        BlockState state = this.block.m_49966_();
        for (Map.Entry<Property<?>, Comparable<?>> entry : this.properties.entrySet()) {
            if (!state.m_61147_().contains(entry.getKey())) continue;
            state = (BlockState)state.m_61124_(entry.getKey(), entry.getValue());
        }
        return state;
    }

    public void mirror(Mirror mirror) {
        BlockState mirrored = this.asBlockState().m_60715_(mirror);
        for (Map.Entry entry : mirrored.m_61148_().entrySet()) {
            if (!this.properties.containsKey(entry.getKey())) continue;
            this.properties.put((Property)entry.getKey(), (Comparable)entry.getValue());
        }
    }

    public void rotate(Rotation rotation) {
        BlockState rotated = this.asBlockState().m_60717_(rotation);
        for (Map.Entry entry : rotated.m_61148_().entrySet()) {
            if (!this.properties.containsKey(entry.getKey())) continue;
            this.properties.put((Property)entry.getKey(), (Comparable)entry.getValue());
        }
    }

    public PartialState copy() {
        PartialState state = PartialState.of(this.block);
        state.properties.putAll(this.properties);
        return state;
    }

    public Tag toNBT(CompoundTag nbt) {
        nbt.m_128359_("Name", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.block).toString());
        if (!this.properties.isEmpty()) {
            CompoundTag compoundtag1 = new CompoundTag();
            for (Map.Entry<Property<?>, Comparable<?>> entry : this.properties.entrySet()) {
                Property<?> property = entry.getKey();
                compoundtag1.m_128359_(property.m_61708_(), property.m_6940_(entry.getValue()));
            }
            nbt.m_128365_("Properties", (Tag)compoundtag1);
        }
        return nbt;
    }

    public static PartialState fromNBT(CompoundTag nbt) {
        if (!nbt.m_128425_("Name", 8)) {
            return PartialState.of(ModBlocks.ERROR_BLOCK);
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("Name")));
        HashMap properties = new HashMap();
        if (nbt.m_128425_("Properties", 10)) {
            CompoundTag propertiesNBT = nbt.m_128469_("Properties");
            for (String s : propertiesNBT.m_128431_()) {
                Property property = block.m_49965_().m_61081_(s);
                if (property == null) continue;
                Optional valueOpt = property.m_6215_(propertiesNBT.m_128461_(s));
                if (valueOpt.isPresent()) {
                    properties.put(property, (Comparable)valueOpt.get());
                    continue;
                }
                VaultMod.LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)s, (Object)propertiesNBT.m_128461_(s), (Object)nbt.toString());
            }
        }
        return new PartialState(block, properties);
    }
}

