/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.time;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.vault.time.modifier.ClockModifier;
import iskallia.vault.init.ModSounds;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TickTimer
extends TickClock {
    public static final SupplierKey<TickClock> KEY = (SupplierKey)SupplierKey.of("tick_timer", TickClock.class).with(Version.v1_0, (TickClock)((Object)((Supplier<TickClock>)TickTimer::new)));
    public static final FieldRegistry FIELDS = TickClock.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Integer> PANIC_TIME = (FieldKey)FieldKey.of("panic_time", Integer.class).with(Version.v1_0, Adapter.ofInt(), DISK.all().or(CLIENT.all())).register(FIELDS);

    public TickTimer() {
        this.set(PANIC_TIME, 400);
        this.set(MODIFIERS, new ClockModifier.List());
    }

    @Override
    public SupplierKey<TickClock> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    protected void tickTime() {
        this.set(LOGICAL_TIME, (Integer)this.get(LOGICAL_TIME) + 1);
        this.set(DISPLAY_TIME, (Integer)this.get(DISPLAY_TIME) - 1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void tickClient() {
        if (!this.has(PAUSED) && (Integer)this.get(DISPLAY_TIME) > 0 && (Integer)this.get(DISPLAY_TIME) < this.get(PANIC_TIME) && (Integer)this.get(DISPLAY_TIME) % 20 == 0) {
            float pitch = 2.0f - (float)((Integer)this.get(DISPLAY_TIME)).intValue() / (float)this.get(PANIC_TIME).intValue();
            SimpleSoundInstance sound = SimpleSoundInstance.m_119752_((SoundEvent)ModSounds.TIMER_PANIC_TICK_SFX, (float)pitch);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    @Override
    protected int getTextColor(int time) {
        if (time < this.get(PANIC_TIME) && time % 10 < 5) {
            return -65536;
        }
        return super.getTextColor(time);
    }

    @Override
    protected float getRotationTime(int time) {
        float value = super.getRotationTime(time);
        if (time <= this.get(PANIC_TIME)) {
            value /= 4.0f;
        }
        return value;
    }
}

