/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.stat;

import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.compound.ItemStackList;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.stat.ChestStat;
import iskallia.vault.core.vault.stat.MinedBlocksStat;
import iskallia.vault.core.vault.stat.MobsStat;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.VaultRarity;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class StatCollector
extends DataObject<StatCollector> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<ChestStat.List> CHESTS = (FieldKey)FieldKey.of("chests", ChestStat.List.class).with(Version.v1_0, Adapter.ofCompound(ChestStat.List::new), DISK.all()).register(FIELDS);
    public static final FieldKey<MinedBlocksStat> MINED_BLOCKS = (FieldKey)FieldKey.of("mined_blocks", MinedBlocksStat.class).with(Version.v1_0, Adapter.ofCompound(MinedBlocksStat::new), DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> TREASURE_ROOMS_OPENED = (FieldKey)FieldKey.of("treasure_rooms_opened", Integer.class).with(Version.v1_0, Adapter.ofSegmentedInt(7), DISK.all()).register(FIELDS);
    public static final FieldKey<MobsStat> MOBS = (FieldKey)FieldKey.of("mobs", MobsStat.class).with(Version.v1_0, Adapter.ofCompound(MobsStat::new), DISK.all()).register(FIELDS);
    public static final FieldKey<Completion> COMPLETION = (FieldKey)FieldKey.of("completion", Completion.class).with(Version.v1_0, Adapter.ofEnum(Completion.class), DISK.all()).register(FIELDS);
    public static final FieldKey<Float> EXP_MULTIPLIER = (FieldKey)FieldKey.of("exp_multiplier", Float.class).with(Version.v1_0, Adapter.ofFloat(), DISK.all()).register(FIELDS);
    public static final FieldKey<ItemStackList> REWARD = (FieldKey)FieldKey.of("reward", ItemStackList.class).with(Version.v1_0, Adapter.ofCompound(ItemStackList::create), DISK.all()).register(FIELDS);

    public StatCollector() {
        this.set(CHESTS, new ChestStat.List());
        this.set(MINED_BLOCKS, new MinedBlocksStat());
        this.set(TREASURE_ROOMS_OPENED, 0);
        this.set(MOBS, new MobsStat());
        this.set(COMPLETION, Completion.COMPLETED);
        this.set(EXP_MULTIPLIER, Float.valueOf(1.0f));
        this.set(REWARD, ItemStackList.create());
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initServer(VirtualWorld world, Vault vault, UUID uuid) {
        CommonEvents.CHEST_LOOT_GENERATION.post().register(this, data -> {
            if (!data.getPlayer().m_142081_().equals(uuid)) {
                return;
            }
            Block block = data.getState().m_60734_();
            if (!(block instanceof VaultChestBlock)) {
                return;
            }
            VaultChestBlock chest = (VaultChestBlock)block;
            this.get(CHESTS).add(ChestStat.ofLoot(chest.getType(), data.getRarity()));
        });
        CommonEvents.PLAYER_MINE.register(this, event -> {
            if (!event.getPlayer().m_142081_().equals(uuid)) {
                return;
            }
            this.get(MINED_BLOCKS).onMine(event.getState(), event.getPlayer());
        });
        CommonEvents.TREASURE_ROOM_OPEN.register(this, data -> {
            if (!data.getPlayer().m_142081_().equals(uuid)) {
                return;
            }
            this.modify(TREASURE_ROOMS_OPENED, count -> count + 1);
        });
        CommonEvents.ENTITY_DEATH.register(this, event -> {
            Entity source = event.getSource().m_7639_();
            if (source == null || !source.m_142081_().equals(uuid)) {
                return;
            }
            this.get(MOBS).onKilled(event.getEntity());
        });
        CommonEvents.ENTITY_DAMAGE.register(this, event -> {
            Entity source = event.getSource().m_7639_();
            if (source == null || !source.m_142081_().equals(uuid)) {
                return;
            }
            this.get(MOBS).onDamageDealt(event.getEntity(), event.getAmount());
        });
        CommonEvents.ENTITY_DAMAGE.register(this, event -> {
            Entity source = event.getSource().m_7639_();
            if (source == null || !event.getEntity().m_142081_().equals(uuid)) {
                return;
            }
            this.get(MOBS).onDamageReceived(source, event.getAmount());
        });
    }

    public void releaseServer() {
        CommonEvents.release(this);
    }

    public int getLootedChests(VaultChestType type, VaultRarity rarity) {
        return (int)this.get(CHESTS).stream().filter(stat -> !stat.has(ChestStat.TRAPPED) && stat.get(ChestStat.TYPE) == type && stat.get(ChestStat.RARITY) == rarity).count();
    }

    public int getTrappedChests(VaultChestType type) {
        return (int)this.get(CHESTS).stream().filter(stat -> stat.has(ChestStat.TRAPPED) && stat.get(ChestStat.TYPE) == type).count();
    }

    public Object2IntMap<ResourceLocation> getMinedBlocks() {
        Object2IntOpenHashMap result = new Object2IntOpenHashMap();
        this.get(MINED_BLOCKS).forEach((arg_0, arg_1) -> StatCollector.lambda$getMinedBlocks$9((Object2IntMap)result, arg_0, arg_1));
        return result;
    }

    public float getExpMultiplier() {
        return this.get(EXP_MULTIPLIER).floatValue();
    }

    public List<ItemStack> getReward() {
        return this.get(REWARD).stream().toList();
    }

    public int getTreasureRoomsOpened() {
        return this.get(TREASURE_ROOMS_OPENED);
    }

    public Object2IntMap<ResourceLocation> getEntitiesKilled() {
        Object2IntOpenHashMap result = new Object2IntOpenHashMap();
        this.get(MOBS).forEach((arg_0, arg_1) -> StatCollector.lambda$getEntitiesKilled$10((Object2IntMap)result, arg_0, arg_1));
        return result;
    }

    public Object2FloatMap<ResourceLocation> getDamageDealt() {
        Object2FloatOpenHashMap result = new Object2FloatOpenHashMap();
        this.get(MOBS).forEach((arg_0, arg_1) -> StatCollector.lambda$getDamageDealt$11((Object2FloatMap)result, arg_0, arg_1));
        return result;
    }

    public Object2FloatMap<ResourceLocation> getDamageReceived() {
        Object2FloatOpenHashMap result = new Object2FloatOpenHashMap();
        this.get(MOBS).forEach((arg_0, arg_1) -> StatCollector.lambda$getDamageReceived$12((Object2FloatMap)result, arg_0, arg_1));
        return result;
    }

    public int getExperience(Vault vault) {
        return ModConfigs.VAULT_STATS.getExperience(vault, this);
    }

    public Completion getCompletion() {
        return this.get(COMPLETION);
    }

    private static /* synthetic */ void lambda$getDamageReceived$12(Object2FloatMap result, ResourceLocation id, MobsStat.Entry entry) {
        result.put((Object)id, entry.get(MobsStat.Entry.DAMAGE_RECEIVED).floatValue());
    }

    private static /* synthetic */ void lambda$getDamageDealt$11(Object2FloatMap result, ResourceLocation id, MobsStat.Entry entry) {
        result.put((Object)id, entry.get(MobsStat.Entry.DAMAGE_DEALT).floatValue());
    }

    private static /* synthetic */ void lambda$getEntitiesKilled$10(Object2IntMap result, ResourceLocation id, MobsStat.Entry entry) {
        result.put((Object)id, entry.get(MobsStat.Entry.KILLED).intValue());
    }

    private static /* synthetic */ void lambda$getMinedBlocks$9(Object2IntMap result, ResourceLocation id, MinedBlocksStat.Entry entry) {
        result.put((Object)id, entry.get(MinedBlocksStat.Entry.COUNT).intValue());
    }
}

