/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.player;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.NaturalSpawner;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.vault.time.modifier.ClockModifier;
import iskallia.vault.core.vault.time.modifier.FruitExtension;
import iskallia.vault.core.vault.time.modifier.VoidFluidExtension;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.gear.trinket.effects.VaultExperienceTrinket;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.item.VaultDollItem;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.VaultJoinSnapshotData;
import iskallia.vault.world.vault.modifier.modifier.PlayerInventoryRestoreModifier;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class Runner
extends Listener {
    public static final SupplierKey<Listener> KEY = (SupplierKey)SupplierKey.of("runner", Listener.class).with(Version.v1_0, (Listener)((Object)((Supplier<Listener>)Runner::new)));
    public static final FieldRegistry FIELDS = Listener.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<NaturalSpawner> SPAWNER = (FieldKey)FieldKey.of("spawner", NaturalSpawner.class).with(Version.v1_0, Adapter.ofCompound(NaturalSpawner::new), DISK.all()).register(FIELDS);

    public Runner() {
        this.set(SPAWNER, new NaturalSpawner());
    }

    @Override
    public SupplierKey<Listener> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.PLAYER_INTERACT.register(this, event -> {
            if (event.getPlayer().f_19853_ != world) {
                return;
            }
            if (!event.isCancelable()) {
                return;
            }
            if (!event.getPlayer().m_142081_().equals(this.get(ID))) {
                return;
            }
            if (ModConfigs.VAULT_GENERAL.isBlacklisted(event.getItemStack())) {
                event.setCanceled(true);
            }
        });
        CommonEvents.PLAYER_INTERACT.register(this, event -> {
            if (event.getPlayer().f_19853_ != world) {
                return;
            }
            if (!event.isCancelable()) {
                return;
            }
            if (!event.getPlayer().m_142081_().equals(this.get(ID))) {
                return;
            }
            if (ModConfigs.VAULT_GENERAL.isBlacklisted(event.getWorld().m_8055_(event.getPos()))) {
                event.setCanceled(true);
            }
        });
        CommonEvents.ENTITY_PLACE.register(this, event -> {
            if (!(event.getEntity() instanceof ServerPlayer)) {
                return;
            }
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            if (!event.isCancelable()) {
                return;
            }
            if (!event.getEntity().m_142081_().equals(this.get(ID))) {
                return;
            }
            if (ModConfigs.VAULT_GENERAL.isBlacklisted(event.getWorld().m_8055_(event.getPos()))) {
                event.setCanceled(true);
            }
        });
        CommonEvents.EFFECT_ADDED.register(this, event -> {
            Entity patt3499$temp = event.getEntity();
            if (!(patt3499$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt3499$temp;
            if (player.f_19853_ != world) {
                return;
            }
            if (!player.m_142081_().equals(this.get(ID))) {
                return;
            }
            if (event.getPotionEffect().m_19544_() == ModEffects.TIMER_ACCELERATION) {
                for (ClockModifier modifier : vault.get(Vault.CLOCK).get(TickClock.MODIFIERS)) {
                    VoidFluidExtension voidFluidExtension;
                    if (modifier.has(ClockModifier.CONSUMED) || !(modifier instanceof VoidFluidExtension) || !(voidFluidExtension = (VoidFluidExtension)modifier).get(VoidFluidExtension.PLAYER).equals(this.get(ID))) continue;
                    return;
                }
                vault.get(Vault.CLOCK).addModifier(new VoidFluidExtension((Player)player));
            }
        });
        CommonEvents.FRUIT_EATEN.register(this, data -> {
            Player patt4324$temp = data.getPlayer();
            if (!(patt4324$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt4324$temp;
            if (player.f_19853_ != world) {
                return;
            }
            if (!player.m_142081_().equals(this.get(ID))) {
                return;
            }
            vault.get(Vault.CLOCK).addModifier(new FruitExtension((Player)player, data.getTime()));
        });
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        super.tickServer(world, vault);
        this.ifPresent(SPAWNER, spawner -> {
            if (vault.has(Vault.CLOCK) && vault.get(Vault.CLOCK).get(TickClock.LOGICAL_TIME) < 300) {
                return;
            }
            int vaultLevel = vault.get(Vault.LEVEL).get();
            NaturalSpawner.Config config = ModConfigs.VAULT_MOBS.getForLevel((int)vaultLevel).SPAWNER;
            spawner.setConfig(config).tickServer(world, vault, this);
        });
    }

    @Override
    public void onJoin(VirtualWorld world, Vault vault) {
        super.onJoin(world, vault);
        this.getPlayer().ifPresent(player -> {
            VaultJoinSnapshotData.get(player.m_183503_()).createSnapshot((Player)player);
            VaultDollItem.markDollOnVaultJoin(world, (Player)player, vault.get(Vault.ID));
            List<TrinketHelper.TrinketStack<VaultExperienceTrinket>> trinkets = TrinketHelper.getTrinkets((LivingEntity)player, VaultExperienceTrinket.class);
            for (TrinketHelper.TrinketStack<VaultExperienceTrinket> trinketStack : trinkets) {
                vault.getOptional(Vault.STATS).map(s -> s.get(player.m_142081_())).ifPresent(stats -> stats.modify(StatCollector.EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * (1.0f + ((VaultExperienceTrinket.Config)((VaultExperienceTrinket)((Object)((Object)((Object)((Object)trinketStack.trinket()))))).getConfig()).getExperienceIncrease()))));
            }
            PlayerVaultStats playerStats = PlayerVaultStatsData.get(world).getVaultStats((Player)player);
            int vaultLevel = vault.get(Vault.LEVEL).get();
            int playerLevel = playerStats.getVaultLevel();
            int diff = playerLevel - vaultLevel - 3;
            if (diff > 0) {
                vault.getOptional(Vault.STATS).map(s -> s.get(player.m_142081_())).ifPresent(stats -> stats.modify(StatCollector.EXP_MULTIPLIER, m -> Float.valueOf(Math.max(0.0f, m.floatValue() - 0.1f * (float)diff))));
            }
            vault.get(Vault.MODIFIERS).getModifiers().forEach(modifier -> vault.getOptional(Vault.STATS).map(s -> s.get(player.m_142081_())).ifPresent(stats -> {
                if (modifier instanceof PlayerInventoryRestoreModifier) {
                    PlayerInventoryRestoreModifier playerInventoryRestoreModifier = (PlayerInventoryRestoreModifier)modifier;
                    stats.modify(StatCollector.EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * ((PlayerInventoryRestoreModifier.Properties)playerInventoryRestoreModifier.properties()).experienceMultiplierOnSuccess()));
                }
            }));
        });
    }
}

