/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.player;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.key.registry.ISupplierKey;
import iskallia.vault.core.data.sync.SyncMode;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.util.iterator.MappingIterator;
import iskallia.vault.core.vault.EntityState;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.VaultMessage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class Listener
extends DataObject<Listener>
implements ISupplierKey<Listener> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<UUID> ID = (FieldKey)FieldKey.of("id", UUID.class).with(Version.v1_0, Adapter.ofUUID(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<EntityState> JOIN_STATE = (FieldKey)FieldKey.of("join_state", EntityState.class).with(Version.v1_0, Adapter.ofCompound(EntityState::new), DISK.all()).register(FIELDS);
    public static final FieldKey<Objective.IdList> OBJECTIVES = (FieldKey)FieldKey.of("objectives", Objective.IdList.class).with(Version.v1_0, Adapter.ofCompound(Objective.IdList::new), DISK.all().or(CLIENT.all())).register(FIELDS);

    public Listener() {
        this.set(OBJECTIVES, new Objective.IdList());
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public UUID getId() {
        return this.get(ID);
    }

    public void initServer(VirtualWorld world, Vault vault) {
    }

    public void tickServer(VirtualWorld world, Vault vault) {
        this.getPlayer().ifPresent(player -> ModNetwork.CHANNEL.sendTo((Object)new VaultMessage.Sync((ServerPlayer)player, vault, SyncMode.FULL), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
    }

    public void releaseServer() {
        CommonEvents.release(this);
    }

    public void onJoin(VirtualWorld world, Vault vault) {
        vault.ifPresent(Vault.MODIFIERS, modifiers -> modifiers.onListenerAdd(world, vault, this));
    }

    public void onLeave(VirtualWorld world, Vault vault) {
        vault.ifPresent(Vault.MODIFIERS, modifiers -> modifiers.onListenerRemove(world, vault, this));
        this.getPlayer().ifPresent(player -> ModNetwork.CHANNEL.sendTo((Object)new VaultMessage.Unload(vault), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
    }

    public Optional<ServerPlayer> getPlayer() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return Optional.ofNullable(server.m_6846_().m_11259_(this.get(ID)));
    }

    public boolean isOnline() {
        return this.getPlayer().isPresent();
    }

    public Iterator<Objective> getObjectives(Vault vault) {
        return new MappingIterator<Integer, Objective>(this.get(OBJECTIVES).iterator(), index -> {
            if (!vault.has(Vault.OBJECTIVES)) {
                return null;
            }
            return (Objective)vault.get(Vault.OBJECTIVES).get(Objectives.LIST).get((int)index);
        });
    }

    public void addObjective(Vault vault, Objective objective) {
        this.addObjective(vault, objective, this.get(OBJECTIVES).size());
    }

    public void addObjective(Vault vault, Objective objective, int priority) {
        this.get(OBJECTIVES).add(objective.get(Objective.ID), priority);
    }

    public int getPriority(Objective objective) {
        return this.get(OBJECTIVES).indexOf(objective.get(Objective.ID));
    }

    public boolean isActive(Vault vault, Objective objective) {
        Iterator iterator = this.get(OBJECTIVES).iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            boolean active = vault.get(Vault.OBJECTIVES).get(index).map(other -> other.isActive(vault, objective)).orElse(false);
            if (!active) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderObjectives(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        Iterator iterator = this.get(OBJECTIVES).iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            boolean rendered = vault.get(Vault.OBJECTIVES).get(index).map(other -> other.render(matrixStack, window, partialTicks, player)).orElse(false);
            if (!rendered) continue;
            return;
        }
    }

    public static class Map
    extends DataMap<Map, UUID, Listener> {
        public Map() {
            super(new HashMap(), Adapter.ofUUID(), Adapter.ofRegistryValue(() -> VaultRegistry.LISTENER, ISupplierKey::getKey, Supplier::get));
        }
    }
}

