/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.player;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.compound.UUIDList;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.ListenersLogic;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.vault.time.modifier.RelicExtension;
import iskallia.vault.core.vault.time.modifier.TrinketExtension;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.event.event.VaultJoinForgeEvent;
import iskallia.vault.event.event.VaultLeaveForgeEvent;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.gear.trinket.effects.VaultTimeExtensionTrinket;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.world.data.VaultPartyData;
import iskallia.vault.world.data.VaultPlayerStats;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ClassicListenersLogic
extends ListenersLogic {
    public static final SupplierKey<ListenersLogic> KEY = (SupplierKey)SupplierKey.of("classic", ListenersLogic.class).with(Version.v1_0, (ListenersLogic)((Object)((Supplier<ListenersLogic>)ClassicListenersLogic::new)));
    public static final FieldRegistry FIELDS = ListenersLogic.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Integer> MAX_PLAYERS = (FieldKey)FieldKey.of("max_players", Integer.class).with(Version.v1_0, Adapter.ofSegmentedInt(3), DISK.all()).register(FIELDS);
    public static final FieldKey<Void> NATURAL_REGEN = (FieldKey)FieldKey.of("natural_regen", Void.class).with(Version.v1_0, Adapter.ofVoid(), DISK.all()).register(FIELDS);
    public static final FieldKey<Void> ADDED_BONUS_TIME = (FieldKey)FieldKey.of("added_bonus_time", Void.class).with(Version.v1_0, Adapter.ofVoid(), DISK.all()).register(FIELDS);
    public static final FieldKey<UUIDList> LEAVERS = (FieldKey)FieldKey.of("leavers", UUIDList.class).with(Version.v1_0, Adapter.ofCompound(UUIDList::create), DISK.all()).register(FIELDS);

    public ClassicListenersLogic() {
        this.set(LEAVERS, UUIDList.create());
    }

    @Override
    public SupplierKey<ListenersLogic> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.PLAYER_REGEN.register(this, data -> {
            Listener listener = vault.get(Vault.LISTENERS).get(data.getPlayer().m_142081_());
            if (!(listener instanceof Runner) || this.has(NATURAL_REGEN)) {
                return;
            }
            data.setAmount(0.0f);
        });
        CommonEvents.LISTENER_LEAVE.register(this, data -> {
            ServerPlayer player = data.getListener().getPlayer().orElse(null);
            if (data.getVault() != vault || !(data.getListener() instanceof Runner) || player == null) {
                return;
            }
            StatCollector stats = vault.get(Vault.STATS).get(data.getListener().get(Listener.ID));
            if (stats == null) {
                return;
            }
            Completion completion = stats.getCompletion();
            TextComponent prefix = new TextComponent(switch (completion) {
                default -> throw new IncompatibleClassChangeError();
                case Completion.COMPLETED -> " completed the Vault!";
                case Completion.BAILED -> " survived.";
                case Completion.FAILED -> " was defeated.";
            });
            prefix.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
            MutableComponent playerName = player.m_5446_().m_6881_();
            playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
            world.m_142572_().m_6846_().m_11264_((Component)playerName.m_7220_((Component)prefix), ChatType.CHAT, player.m_142081_());
        });
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault, Map<UUID, Listener> listeners) {
        List<Listener> runners = listeners.values().stream().filter(listener -> listener instanceof Runner).toList();
        this.keepInVault(world, vault, runners);
        if (runners.stream().noneMatch(Listener::isOnline)) {
            vault.ifPresent(Vault.CLOCK, clock -> clock.set(TickClock.PAUSED));
        } else {
            vault.ifPresent(Vault.CLOCK, clock -> clock.remove(TickClock.PAUSED));
        }
        if (runners.isEmpty()) {
            for (Listener listener2 : vault.get(Vault.LISTENERS).getAll()) {
                vault.get(Vault.LISTENERS).remove(world, vault, listener2);
            }
        }
        if (vault.get(Vault.LISTENERS).getAll().isEmpty()) {
            world.markForDeletion();
            vault.set(Vault.FINISHED);
            vault.releaseServer();
        }
    }

    @Override
    public void releaseServer() {
        CommonEvents.release(this);
    }

    @Override
    public boolean onJoin(VirtualWorld world, Vault vault, Listener listener) {
        VaultPartyData.Party party;
        long active;
        if (vault.get(Vault.LISTENERS).contains(listener.get(Listener.ID))) {
            return false;
        }
        if (this.has(MAX_PLAYERS) && (active = vault.get(Vault.LISTENERS).getAll().stream().filter(l -> l instanceof Runner).count()) >= (long)this.get(MAX_PLAYERS).intValue() && listener instanceof Runner) {
            listener.getPlayer().ifPresent(player -> player.m_5661_((Component)new TextComponent("This vault has reached max capacity.").m_130940_(ChatFormatting.RED), true));
            return false;
        }
        if (this.has(LEAVERS) && this.get(LEAVERS).contains(listener.get(Listener.ID))) {
            listener.getPlayer().ifPresent(player -> player.m_5661_((Component)new TextComponent("You cannot re-enter this vault.").m_130940_(ChatFormatting.RED), true));
            return false;
        }
        if (vault.has(Vault.OWNER) && world.m_46469_().m_46207_(ModGameRules.VAULT_JOIN_REQUIRE_PARTY) && ((party = (VaultPartyData.Party)VaultPartyData.get(world).getParty(vault.get(Vault.OWNER)).orElse(null)) == null || !party.hasMember(listener.get(Listener.ID)))) {
            listener.getPlayer().ifPresent(player -> player.m_5661_((Component)new TextComponent("This vault is reserved for allowed party members.").m_130940_(ChatFormatting.RED), true));
            return false;
        }
        vault.set(Vault.OWNER, listener.get(Listener.ID));
        if (!this.has(ADDED_BONUS_TIME) && listener instanceof Runner) {
            vault.get(Vault.CLOCK).addModifier(new RelicExtension(listener.get(Listener.ID), 600));
            this.set(ADDED_BONUS_TIME);
        }
        listener.getPlayer().ifPresent(player -> {
            TrinketHelper.getTrinkets((LivingEntity)player).forEach(trinket -> {
                if (!TrinketItem.hasUsesLeft(trinket.stack())) {
                    return;
                }
                if (!TrinketItem.isIdentified(trinket.stack())) {
                    return;
                }
                TrinketItem.addUsedVault(trinket.stack(), vault.get(Vault.ID));
            });
            TrinketHelper.getTrinkets((LivingEntity)player, VaultTimeExtensionTrinket.class).forEach(timeTrinket -> {
                if (!timeTrinket.isUsable((Player)player)) {
                    return;
                }
                vault.get(Vault.CLOCK).addModifier(new TrinketExtension((Player)player, ((VaultTimeExtensionTrinket.Config)((VaultTimeExtensionTrinket)((Object)((Object)((Object)timeTrinket.trinket())))).getConfig()).getTimeAdded()));
            });
        });
        return true;
    }

    @Override
    protected void onTeleport(VirtualWorld world, Vault vault, ServerPlayer player) {
        MinecraftForge.EVENT_BUS.post((Event)new VaultJoinForgeEvent(vault));
        TextComponent title = new TextComponent("The Vault");
        title.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14536734)));
        MutableComponent subtitle = new TextComponent("Good luck, ").m_7220_(player.m_7755_()).m_7220_((Component)new TextComponent("!"));
        subtitle.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14536734)));
        ClientboundSetTitleTextPacket titlePacket = new ClientboundSetTitleTextPacket((Component)title);
        ClientboundSetSubtitleTextPacket subtitlePacket = new ClientboundSetSubtitleTextPacket((Component)subtitle);
        player.f_8906_.m_141995_((Packet)titlePacket);
        player.f_8906_.m_141995_((Packet)subtitlePacket);
        this.printJoinMessage(world, vault, player);
    }

    private void printJoinMessage(VirtualWorld world, Vault vault, ServerPlayer player) {
        TextComponent text = new TextComponent("");
        AtomicBoolean startsWithVowel = new AtomicBoolean(false);
        ObjectIterator it = vault.get(Vault.MODIFIERS).getDisplayGroup().object2IntEntrySet().iterator();
        while (it.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            text.m_130946_(entry.getIntValue() + "x ");
            text.m_7220_(((VaultModifier)entry.getKey()).getNameComponentFormatted(entry.getIntValue()));
            if (it.hasNext()) {
                text.m_7220_((Component)new TextComponent(", "));
                continue;
            }
            text.m_7220_((Component)new TextComponent(" "));
        }
        TextComponent prefix = new TextComponent(startsWithVowel.get() ? " entered an " : " entered a ");
        text.m_130946_("Vault").m_130946_("!");
        prefix.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
        text.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
        MutableComponent playerName = player.m_5446_().m_6881_();
        playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
        world.m_142572_().m_6846_().m_11264_((Component)playerName.m_7220_((Component)prefix).m_7220_((Component)text), ChatType.CHAT, player.m_142081_());
    }

    @Override
    public boolean onLeave(VirtualWorld world, Vault vault, Listener listener) {
        return listener.getPlayer().map(player -> {
            if (!player.m_21224_()) {
                this.recallToJoinState(Stream.of(listener));
            }
            VaultPlayerStats.addStats(player.m_142081_(), vault.get(Vault.ID));
            MinecraftForge.EVENT_BUS.post((Event)new VaultLeaveForgeEvent((ServerPlayer)player, vault));
            this.get(LEAVERS).add(player.m_142081_());
            return true;
        }).orElse(false);
    }
}

