/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.overlay.ModifiersRenderer;
import iskallia.vault.core.vault.player.Listener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class VaultOverlay
extends DataObject<VaultOverlay> {
    public static final ResourceLocation VAULT_HUD = VaultMod.id("textures/gui/vault_hud.png");
    public static final ResourceLocation ARCHITECT_HUD = VaultMod.id("textures/gui/architect_event_bar.png");
    public static final ResourceLocation VIGNETTE = VaultMod.id("textures/gui/vignette.png");
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<Void> VISIBLE = (FieldKey)FieldKey.of("visible", Void.class).with(Version.v1_0, Adapter.ofVoid(), DISK.all().or(CLIENT.all())).register(FIELDS);

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient(Vault vault) {
        ClientEvents.RENDER_OVERLAY.forType(RenderGameOverlayEvent.ElementType.ALL).register(vault, data -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null || !world.m_46472_().m_135782_().equals((Object)vault.get(Vault.WORLD).get(WorldManager.KEY))) {
                return;
            }
            this.render(vault, data.getMatrixStack(), data.getWindow(), data.getPartialTicks());
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(Vault vault, PoseStack matrixStack, Window window, float partialTicks) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        vault.ifPresent(Vault.LISTENERS, listeners -> {
            if (player == null) {
                return;
            }
            Listener listener = listeners.get(player.m_142081_());
            if (listener == null) {
                return;
            }
            listener.renderObjectives(vault, matrixStack, window, partialTicks, (Player)player);
        });
        vault.ifPresent(Vault.CLOCK, clock -> {
            matrixStack.m_85836_();
            matrixStack.m_85837_(92.0, (double)(window.m_85446_() - 25), 0.0);
            clock.render(matrixStack);
            matrixStack.m_85849_();
        });
        vault.ifPresent(Vault.MODIFIERS, modifiers -> ModifiersRenderer.renderVaultModifiers(modifiers, matrixStack));
    }
}

