/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.scavenger;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataList;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.adapter.DirectAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.vault.objective.Objective;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ScavengerGoal
extends DataObject<ScavengerGoal> {
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Item> ITEM = (FieldKey)FieldKey.of("item", Item.class).with(Version.v1_0, new DirectAdapter<Item>((buffer, context, value) -> buffer.writeIdentifier(value.getRegistryName()), (buffer, context) -> (Item)ForgeRegistries.ITEMS.getValue(buffer.readIdentifier())), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> TOTAL = (FieldKey)FieldKey.of("total", Integer.class).with(Version.v1_0, Adapter.ofSegmentedInt(3), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> CURRENT = (FieldKey)FieldKey.of("current", Integer.class).with(Version.v1_0, Adapter.ofSegmentedInt(3), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<ResourceLocation> ICON = (FieldKey)FieldKey.of("secondary_icon", ResourceLocation.class).with(Version.v1_0, Adapter.ofIdentifier(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> COLOR = (FieldKey)FieldKey.of("color", Integer.class).with(Version.v1_0, Adapter.ofInt(), DISK.all().or(CLIENT.all())).register(FIELDS);

    protected ScavengerGoal() {
    }

    public ScavengerGoal(Item item, int count, ResourceLocation icon, int color) {
        this.set(ITEM, item);
        this.set(TOTAL, count);
        this.set(CURRENT, 0);
        this.set(ICON, icon);
        this.set(COLOR, color);
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public boolean isCompleted() {
        return this.get(CURRENT) >= this.get(TOTAL);
    }

    public boolean consume(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (this.get(CURRENT) >= this.get(TOTAL)) {
            return false;
        }
        if (this.get(ITEM) != stack.m_41720_()) {
            return false;
        }
        int amount = Math.min(this.get(TOTAL) - this.get(CURRENT), stack.m_41613_());
        stack.m_41774_(amount);
        this.modify(CURRENT, value -> value + amount);
        return true;
    }

    public boolean canConsume(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (this.get(CURRENT) >= this.get(TOTAL)) {
            return false;
        }
        return this.get(ITEM) == stack.m_41720_();
    }

    public static class ObjList
    extends DataList<ObjList, ScavengerGoal> {
        public ObjList() {
            super(new ArrayList(), Adapter.ofCompound(ScavengerGoal::new));
        }

        public boolean areAllCompleted() {
            return this.stream().allMatch(ScavengerGoal::isCompleted);
        }
    }
}

