/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.scavenger;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.ScavengerObjective;
import iskallia.vault.core.vault.objective.scavenger.ChestScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.CoinStacksScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.MobScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengerGoal;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ScavengeTask {
    public abstract Optional<ScavengerGoal> generateGoal(int var1, RandomSource var2);

    public abstract void initServer(VirtualWorld var1, Vault var2, ScavengerObjective var3);

    public ItemStack createStack(Vault vault, Item item) {
        ItemStack stack = new ItemStack((ItemLike)item, 1);
        stack.m_41784_().m_128359_("VaultId", vault.get(Vault.ID).toString());
        return stack;
    }

    public static class Adapter
    implements JsonSerializer<ScavengeTask>,
    JsonDeserializer<ScavengeTask> {
        public static final Adapter INSTANCE = new Adapter();

        public ScavengeTask deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            switch (object.get("type").getAsString()) {
                case "chest": {
                    WeightedList<ChestScavengeTask.Entry> entries = new WeightedList<ChestScavengeTask.Entry>();
                    JsonObject obj = object.get("entries").getAsJsonObject();
                    for (String key : obj.keySet()) {
                        JsonObject value = obj.get(key).getAsJsonObject();
                        entries.put(new ChestScavengeTask.Entry((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(key)), value.get("color").getAsInt()), value.get("weight").getAsInt());
                    }
                    return new ChestScavengeTask(object.get("target").getAsString(), object.get("probability").getAsDouble(), object.get("multiplier").getAsDouble(), new ResourceLocation(object.get("icon").getAsString()), entries);
                }
                case "coin_stacks": {
                    WeightedList<CoinStacksScavengeTask.Entry> entries = new WeightedList<CoinStacksScavengeTask.Entry>();
                    JsonObject obj = object.get("entries").getAsJsonObject();
                    for (String key : obj.keySet()) {
                        JsonObject value = obj.get(key).getAsJsonObject();
                        entries.put(new CoinStacksScavengeTask.Entry((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(key)), value.get("color").getAsInt()), value.get("weight").getAsInt());
                    }
                    return new CoinStacksScavengeTask(object.get("probability").getAsDouble(), object.get("multiplier").getAsDouble(), new ResourceLocation(object.get("icon").getAsString()), entries);
                }
                case "mob": {
                    ArrayList<MobScavengeTask.Entry> entries = new ArrayList<MobScavengeTask.Entry>();
                    JsonObject obj = object.get("entries").getAsJsonObject();
                    for (String key : obj.keySet()) {
                        JsonArray list = obj.get(key).getAsJsonArray();
                        HashSet<ResourceLocation> group = new HashSet<ResourceLocation>();
                        for (JsonElement element : list) {
                            group.add(new ResourceLocation(element.getAsString()));
                        }
                        entries.add(new MobScavengeTask.Entry((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(key)), group));
                    }
                    return new MobScavengeTask(object.get("probability").getAsDouble(), object.get("multiplier").getAsDouble(), new ResourceLocation(object.get("icon").getAsString()), object.get("color").getAsInt(), (MobScavengeTask.Entry[])entries.toArray(MobScavengeTask.Entry[]::new));
                }
            }
            return null;
        }

        public JsonElement serialize(ScavengeTask value, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            if (value instanceof ChestScavengeTask) {
                ChestScavengeTask chest = (ChestScavengeTask)value;
                object.addProperty("type", "chest");
                object.addProperty("target", chest.target);
                object.addProperty("probability", (Number)chest.probability);
                object.addProperty("icon", chest.icon.toString());
                JsonObject entries = new JsonObject();
                chest.entries.forEach((entry, weight) -> {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("weight", (Number)weight);
                    obj.addProperty("color", (Number)entry.color);
                    entries.add(entry.item.getRegistryName().toString(), (JsonElement)obj);
                });
                object.add("entries", (JsonElement)entries);
            } else if (value instanceof CoinStacksScavengeTask) {
                CoinStacksScavengeTask coin = (CoinStacksScavengeTask)value;
                object.addProperty("type", "coin_stacks");
                object.addProperty("probability", (Number)coin.probability);
                object.addProperty("icon", coin.icon.toString());
                JsonObject entries = new JsonObject();
                coin.entries.forEach((entry, weight) -> {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("weight", (Number)weight);
                    obj.addProperty("color", (Number)entry.color);
                    entries.add(entry.item.getRegistryName().toString(), (JsonElement)obj);
                });
                object.add("entries", (JsonElement)entries);
            } else if (value instanceof MobScavengeTask) {
                MobScavengeTask mob = (MobScavengeTask)value;
                object.addProperty("type", "mob");
                object.addProperty("probability", (Number)mob.probability);
                object.addProperty("icon", mob.icon.toString());
                object.addProperty("color", (Number)mob.color);
                JsonObject entries = new JsonObject();
                for (MobScavengeTask.Entry entry2 : mob.entries) {
                    JsonArray group = new JsonArray();
                    entry2.group.forEach(id -> group.add(id.toString()));
                    entries.add(entry2.item.getRegistryName().toString(), (JsonElement)group);
                }
                object.add("entries", (JsonElement)entries);
            }
            return object;
        }
    }
}

