/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.scavenger;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.ScavengerObjective;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengerGoal;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MobScavengeTask
extends ScavengeTask {
    public final double probability;
    public final double multiplier;
    public final ResourceLocation icon;
    public final int color;
    public final List<Entry> entries;

    public MobScavengeTask(double probability, double multiplier, ResourceLocation icon, int color, Entry ... entries) {
        this.probability = probability;
        this.multiplier = multiplier;
        this.icon = icon;
        this.color = color;
        this.entries = Arrays.asList(entries);
    }

    @Override
    public Optional<ScavengerGoal> generateGoal(int count, RandomSource random) {
        Entry entry = this.entries.get(random.nextInt(this.entries.size()));
        return Optional.of(new ScavengerGoal(entry.item, (int)Math.ceil((double)count * this.multiplier), this.icon, this.color));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ScavengerObjective objective) {
        CommonEvents.ENTITY_DROPS.register(objective, event -> {
            LivingEntity entity = event.getEntityLiving();
            if (entity.f_19853_ != world) {
                return;
            }
            if (world.m_5822_().nextDouble() >= this.probability) {
                return;
            }
            List<Entry> matchingEntries = this.entries.stream().filter(entry -> entry.group.contains(entity.m_6095_().getRegistryName())).toList();
            if (matchingEntries.isEmpty()) {
                return;
            }
            Entry entry2 = matchingEntries.get(world.m_5822_().nextInt(matchingEntries.size()));
            ItemStack stack = this.createStack(vault, entry2.item);
            ItemEntity item = new ItemEntity((Level)world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
            event.getDrops().add(item);
        });
    }

    public static class Entry {
        public final Item item;
        public final Set<ResourceLocation> group;

        public Entry(Item item, EntityType<?> ... group) {
            this.item = item;
            this.group = new LinkedHashSet<ResourceLocation>(Arrays.stream(group).map(ForgeRegistryEntry::getRegistryName).toList());
        }

        public Entry(Item item, Set<ResourceLocation> group) {
            this.item = item;
            this.group = group;
        }
    }
}

