/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.scavenger;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.ScavengerObjective;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengerGoal;
import iskallia.vault.core.world.data.PartialTile;
import iskallia.vault.core.world.data.TilePredicate;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ChestScavengeTask
extends ScavengeTask {
    public final String target;
    public final double probability;
    public final double multiplier;
    public final ResourceLocation icon;
    public final WeightedList<Entry> entries;

    public ChestScavengeTask(String target, double probability, double multiplier, ResourceLocation icon, WeightedList<Entry> entries) {
        this.target = target;
        this.probability = probability;
        this.multiplier = multiplier;
        this.icon = icon;
        this.entries = entries;
    }

    @Override
    public Optional<ScavengerGoal> generateGoal(int count, RandomSource random) {
        return this.entries.getRandom(random).map(entry -> new ScavengerGoal(entry.item, (int)Math.ceil((double)count * this.multiplier), this.icon, entry.color));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ScavengerObjective objective) {
        CommonEvents.CHEST_LOOT_GENERATION.post().register(objective, data -> {
            PartialTile tile;
            if (data.getPlayer().f_19853_ != world) {
                return;
            }
            if (world.m_5822_().nextDouble() >= this.probability) {
                return;
            }
            TilePredicate predicate = TilePredicate.of(this.target);
            if (!predicate.test(tile = PartialTile.of(data.getState(), data.getTileEntity().serializeNBT()))) {
                return;
            }
            this.entries.getRandom(world.m_5822_()).ifPresent(entry -> data.getLoot().add(this.createStack(vault, entry.item)));
        });
    }

    public static class Entry {
        public final Item item;
        public final int color;

        public Entry(Item item, int color) {
            this.item = item;
            this.color = color;
        }
    }
}

