/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockSetEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengerGoal;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderProperties;

public class ScavengerObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("scavenger", Objective.class).with(Version.v1_0, (Objective)((Object)((Supplier<Objective>)ScavengerObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<GoalMap> GOALS = (FieldKey)FieldKey.of("goals", GoalMap.class).with(Version.v1_0, Adapter.ofCompound(GoalMap::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of("objective_probability", Float.class).with(Version.v1_2, Adapter.ofFloat(), DISK.all()).register(FIELDS);

    public ScavengerObjective() {
        this.set(GOALS, new GoalMap());
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register(this, data -> this.ifPresent(OBJECTIVE_PROBABILITY, probability -> data.setProbability(probability.floatValue())));
        BlockState targetState = (BlockState)ModBlocks.PLACEHOLDER.m_49966_().m_61124_(PlaceholderBlock.TYPE, (Comparable)((Object)PlaceholderBlock.Type.OBJECTIVE));
        CommonEvents.BLOCK_SET.at(BlockSetEvent.Type.RETURN).of(targetState).in((LevelWriter)world).register(this, data -> {
            BlockState state = ModBlocks.SCAVENGER_ALTAR.m_49966_();
            data.getWorld().m_7731_(data.getPos(), state, 3);
        });
        CommonEvents.SCAVENGER_ALTAR_CONSUME.register(this, data -> {
            if (data.getLevel() != world || data.getTile().getItemPlacedBy() == null) {
                return;
            }
            Listener listener = vault.get(Vault.LISTENERS).get(data.getTile().getItemPlacedBy());
            if (!(listener instanceof Runner)) {
                return;
            }
            boolean creative = listener.getPlayer().map(ServerPlayer::m_7500_).orElse(false);
            CompoundTag nbt = data.getTile().getHeldItem().m_41783_();
            if (!(creative || nbt != null && nbt.m_128461_("VaultId").equals(vault.get(Vault.ID).toString()))) {
                return;
            }
            List goals = (List)this.get(GOALS).get(listener.get(Listener.ID));
            for (ScavengerGoal goal : goals) {
                goal.consume(data.getTile().getHeldItem());
            }
        });
        for (ScavengeTask task : ModConfigs.SCAVENGER.getTasks()) {
            task.initServer(world, vault, this);
        }
        super.initServer(world, vault);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        if (this.get(GOALS).areAllCompleted(vault)) {
            super.tickServer(world, vault);
        }
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        ScavengerGoal.ObjList goal;
        if (listener instanceof Runner && listener.getPriority(this) < 0) {
            listener.addObjective(vault, this);
            this.generateGoal(vault, listener);
        }
        if ((goal = (ScavengerGoal.ObjList)this.get(GOALS).get(listener.get(Listener.ID))) != null && goal.areAllCompleted()) {
            super.tickListener(world, vault, listener);
        }
    }

    private void generateGoal(Vault vault, Listener listener) {
        ScavengerGoal.ObjList list = new ScavengerGoal.ObjList();
        this.get(GOALS).put(listener.get(Listener.ID), list);
        JavaRandom random = JavaRandom.ofInternal(vault.get(Vault.SEED) ^ listener.get(Listener.ID).getMostSignificantBits());
        list.addAll(ModConfigs.SCAVENGER.generateGoals(vault.get(Vault.LEVEL).get(), random));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(PoseStack matrixStack, Window window, float partialTicks, Player player) {
        ScavengerGoal.ObjList goals = (ScavengerGoal.ObjList)this.get(GOALS).get(player.m_142081_());
        if (goals == null || goals.areAllCompleted()) {
            boolean rendered = false;
            for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
                rendered |= objective.render(matrixStack, window, partialTicks, player);
            }
            if (rendered) {
                return true;
            }
        }
        if (goals == null) {
            return true;
        }
        int totalX = 0;
        int totalY = 0;
        int midX = window.m_85445_() / 2;
        int gapWidth = 7;
        int itemBoxWidth = 32;
        ArrayList<ScavengerGoal> filteredGoals = new ArrayList<ScavengerGoal>(goals);
        filteredGoals.removeIf(ScavengerGoal::isCompleted);
        int totalWidth = filteredGoals.size() * itemBoxWidth + (filteredGoals.size() - 1) * gapWidth;
        int shiftX = -totalWidth / 2 + itemBoxWidth / 2;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        matrixStack.m_85836_();
        int yOffset = 0;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(midX + shiftX), (double)((float)itemBoxWidth * 0.75f), 0.0);
        totalX += midX + shiftX;
        totalY = (int)((double)totalY + (double)itemBoxWidth * 0.75);
        for (ScavengerGoal goal : filteredGoals) {
            int reqYOffset = ScavengerObjective.renderItemRequirement(matrixStack, goal, itemBoxWidth, totalX, totalY);
            if (reqYOffset > yOffset) {
                yOffset = reqYOffset;
            }
            matrixStack.m_85837_((double)(itemBoxWidth + gapWidth), 0.0, 0.0);
            totalX += itemBoxWidth + gapWidth;
        }
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int renderItemRequirement(PoseStack matrixStack, ScavengerGoal goal, int itemBoxWidth, int totalX, int totalY) {
        ItemStack requiredStack = new ItemStack((ItemLike)goal.get(ScavengerGoal.ITEM));
        ResourceLocation iconPath = goal.get(ScavengerGoal.ICON);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, (double)((float)(-itemBoxWidth) / 2.0f), 0.0);
        totalY = (int)((float)totalY + (float)(-itemBoxWidth) / 2.0f);
        ScavengerObjective.renderItemStack(matrixStack, requiredStack, totalX, totalY);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)iconPath);
        matrixStack.m_85836_();
        matrixStack.m_85837_(-16.0, -2.4, 0.0);
        matrixStack.m_85841_(0.4f, 0.4f, 1.0f);
        ScreenDrawHelper.drawTexturedQuads(buf -> ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack).dim(16.0f, 16.0f).draw());
        matrixStack.m_85849_();
        matrixStack.m_85837_(0.0, 10.0, 0.0);
        String requiredText = goal.get(ScavengerGoal.CURRENT) + "/" + goal.get(ScavengerGoal.TOTAL);
        MutableComponent cmp = new TextComponent(requiredText).m_130940_(ChatFormatting.GREEN);
        UIHelper.renderCenteredWrappedText(matrixStack, (Component)cmp, 30, 0);
        matrixStack.m_85837_(0.0, 10.0, 0.0);
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
        Component name = requiredStack.m_41786_();
        MutableComponent display = name.m_6881_().m_130948_(Style.f_131099_.m_178520_(goal.get(ScavengerGoal.COLOR).intValue()));
        int lines = UIHelper.renderCenteredWrappedText(matrixStack, (Component)display, 60, 0);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        return 25 + lines * 5;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderItemStack(PoseStack renderStack, ItemStack item, int totalX, int totalY) {
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer ir = mc.m_91291_();
        Font fr = RenderProperties.get((ItemStack)item).getFont(item);
        if (fr == null) {
            fr = mc.f_91062_;
        }
        ir.f_115093_ = 200.0f;
        ir.m_115203_(item, totalX - 8, totalY - 8);
        ir.m_115174_(fr, item, totalX - 8, totalY - 8, null);
        ir.f_115093_ = 0.0f;
    }

    @Override
    public boolean isActive(Vault vault, Objective objective) {
        if (!this.get(GOALS).areAllCompleted(vault)) {
            return objective == this;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(vault, objective)) continue;
            return true;
        }
        return false;
    }

    public static class GoalMap
    extends DataMap<GoalMap, UUID, ScavengerGoal.ObjList> {
        public GoalMap() {
            super(new HashMap(), Adapter.ofUUID(), Adapter.ofCompound(ScavengerGoal.ObjList::new));
        }

        public boolean areAllCompleted(Vault vault) {
            for (Runner runner : vault.get(Vault.LISTENERS).getAll(Runner.class)) {
                if (!this.containsKey(runner.getId()) || ((ScavengerGoal.ObjList)this.get(runner.getId())).areAllCompleted()) continue;
                return false;
            }
            return true;
        }
    }
}

