/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.block.MonolithBlock;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.gui.overlay.AbilitiesOverlay;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockSetEvent;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.KillBossObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.overlay.VaultOverlay;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.MonolithIgniteMessage;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class MonolithObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("monolith", Objective.class).with(Version.v1_2, (Objective)((Object)((Supplier<Objective>)MonolithObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Integer> COUNT = (FieldKey)FieldKey.of("count", Integer.class).with(Version.v1_0, Adapter.ofSegmentedInt(3), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> TARGET = (FieldKey)FieldKey.of("target", Integer.class).with(Version.v1_0, Adapter.ofSegmentedInt(3), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of("objective_probability", Float.class).with(Version.v1_2, Adapter.ofFloat(), DISK.all()).register(FIELDS);

    protected MonolithObjective() {
    }

    protected MonolithObjective(int target, float objectiveProbability) {
        this.set(COUNT, 0);
        this.set(TARGET, target);
        this.set(OBJECTIVE_PROBABILITY, Float.valueOf(objectiveProbability));
    }

    public static MonolithObjective of(int target, float objectiveProbability) {
        return new MonolithObjective(target, objectiveProbability);
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register(this, data -> this.ifPresent(OBJECTIVE_PROBABILITY, probability -> data.setProbability(probability.floatValue())));
        CommonEvents.BLOCK_USE.in((Level)world).of(ModBlocks.MONOLITH).register(this, data -> {
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            if (this.get(COUNT) >= this.get(TARGET)) {
                return;
            }
            BlockPos pos = data.getPos();
            if (((Boolean)data.getState().m_61143_((Property)MonolithBlock.FILLED)).booleanValue()) {
                return;
            }
            if (data.getState().m_61143_(MonolithBlock.HALF) == DoubleBlockHalf.UPPER && world.m_8055_(pos = pos.m_7495_()).m_60734_() != ModBlocks.MONOLITH) {
                return;
            }
            if (vault.get(Vault.LISTENERS).getObjectivePriority(data.getPlayer().m_142081_(), this) != 0) {
                return;
            }
            world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)MonolithBlock.FILLED, (Comparable)Boolean.valueOf(true)), 3);
            world.m_7731_(pos.m_7494_(), (BlockState)world.m_8055_(pos.m_7494_()).m_61124_((Property)MonolithBlock.FILLED, (Comparable)Boolean.valueOf(true)), 3);
            this.playActivationEffects(world, pos);
            this.set(COUNT, this.get(COUNT) + 1);
            for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
                if (!(objective instanceof KillBossObjective)) continue;
                KillBossObjective killBoss = (KillBossObjective)objective;
                killBoss.set(KillBossObjective.BOSS_POS, pos);
            }
            data.setResult(InteractionResult.SUCCESS);
        });
        BlockState targetState = (BlockState)ModBlocks.PLACEHOLDER.m_49966_().m_61124_(PlaceholderBlock.TYPE, (Comparable)((Object)PlaceholderBlock.Type.OBJECTIVE));
        CommonEvents.BLOCK_SET.at(BlockSetEvent.Type.RETURN).of(targetState).in((LevelWriter)world).register(this, data -> {
            BlockPos pos = data.getPos();
            BlockState lower = (BlockState)((BlockState)ModBlocks.MONOLITH.m_49966_().m_61124_(MonolithBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)MonolithBlock.FILLED, (Comparable)Boolean.valueOf(false));
            BlockState upper = (BlockState)((BlockState)ModBlocks.MONOLITH.m_49966_().m_61124_(MonolithBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)MonolithBlock.FILLED, (Comparable)Boolean.valueOf(false));
            data.getWorld().m_7731_(pos, lower, 3);
            data.getWorld().m_7731_(pos.m_7494_(), upper, 3);
        });
        super.initServer(world, vault);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        if (this.get(COUNT) >= this.get(TARGET)) {
            super.tickServer(world, vault);
        }
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener.getPriority(this) < 0) {
            listener.addObjective(vault, this);
        }
        if (listener instanceof Runner && this.get(COUNT) >= this.get(TARGET)) {
            super.tickListener(world, vault, listener);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(PoseStack matrixStack, Window window, float partialTicks, Player player) {
        int i;
        if (this.get(COUNT) >= this.get(TARGET)) {
            boolean rendered = false;
            for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
                rendered |= objective.render(matrixStack, window, partialTicks, player);
            }
            if (rendered) {
                return true;
            }
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(15.0, (double)(window.m_85446_() - 34), 0.0);
        if (AbilitiesOverlay.ABILITY_DATA.shouldRender) {
            matrixStack.m_85837_(0.0, -12.0, 0.0);
        }
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        FormattedCharSequence text = new TextComponent("Monoliths").m_130940_(ChatFormatting.BOLD).m_7532_();
        Minecraft.m_91087_().f_91062_.m_92733_(text, 0.0f, 0.0f, -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        if (this.get(TARGET) <= 0) {
            return false;
        }
        float scale = 0.6f;
        float gap = 2.0f;
        float margin = 2.0f;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int previousTexture = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)VaultOverlay.VAULT_HUD);
        int iconWidth = 12;
        int iconHeight = 22;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, (double)(-margin), 0.0);
        matrixStack.m_85837_(0.0, (double)(-scale * (float)iconHeight), 0.0);
        matrixStack.m_85841_(scale, scale, scale);
        for (i = 0; i < this.get(COUNT); ++i) {
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)103.0f, (float)84.0f, (int)iconWidth, (int)iconHeight, (int)256, (int)256);
            matrixStack.m_85837_((double)(scale * gap + (float)iconWidth), 0.0, 0.0);
        }
        for (i = 0; i < this.get(TARGET) - this.get(COUNT); ++i) {
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)90.0f, (float)84.0f, (int)iconWidth, (int)iconHeight, (int)256, (int)256);
            matrixStack.m_85837_((double)(scale * gap + (float)iconWidth), 0.0, 0.0);
        }
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157453_((int)0, (int)previousTexture);
        return true;
    }

    @Override
    public boolean isActive(Vault vault, Objective objective) {
        if (this.get(COUNT) < this.get(TARGET)) {
            return objective == this;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(vault, objective)) continue;
            return true;
        }
        return false;
    }

    protected void playActivationEffects(VirtualWorld world, BlockPos pos) {
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new MonolithIgniteMessage(pos));
        world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

