/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.compound.IdentifierList;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FindExitObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("find_exit", Objective.class).with(Version.v1_0, (Objective)((Object)((Supplier<Objective>)FindExitObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<IdentifierList> TAGS = (FieldKey)FieldKey.of("tags", IdentifierList.class).with(Version.v1_0, Adapter.ofCompound(), DISK.all().or(CLIENT.all()), IdentifierList::create).register(FIELDS);

    public FindExitObjective() {
        this.set(TAGS, IdentifierList.create());
    }

    public static FindExitObjective create(ResourceLocation ... tags) {
        FindExitObjective objective = new FindExitObjective();
        objective.get(TAGS).addAll(Arrays.asList(tags));
        return objective;
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.VAULT_PORTAL_COLLIDE.in((Level)world).register(this, data -> {
            Listener listener = vault.get(Vault.LISTENERS).get(data.getPlayer().m_142081_());
            if (!(listener instanceof Runner)) {
                return;
            }
            Runner runner = (Runner)listener;
            if (!listener.isActive(vault, this)) {
                return;
            }
            if (data.getPlayer().m_20092_()) {
                return;
            }
            if (!vault.has(Vault.WORLD)) {
                return;
            }
            vault.get(Vault.WORLD).ifPresent(WorldManager.PORTAL_LOGIC, portalLogic -> portalLogic.getPortals().filter(portal -> portal.contains(data.getPos())).filter(portal -> portal.hasAnyTag(this.get(TAGS))).findAny().ifPresent(portal -> vault.get(Vault.LISTENERS).remove(world, vault, runner)));
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(PoseStack matrixStack, Window window, float partialTicks, Player player) {
        int width = window.m_85445_();
        int height = window.m_85446_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        MutableComponent txt = new TextComponent("Find the Exit!").m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.BOLD);
        Minecraft.m_91087_().f_91062_.m_92733_(txt.m_7532_(), 8.0f, (float)(height - 54), -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        return true;
    }

    @Override
    public boolean isActive(Vault vault, Objective objective) {
        return objective == this;
    }
}

