/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.ClassicLootLogic;
import iskallia.vault.core.vault.ClassicMobLogic;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.LootLogic;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.WorldRenderer;
import iskallia.vault.core.vault.influence.Influences;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.objective.VictoryObjective;
import iskallia.vault.core.vault.overlay.VaultOverlay;
import iskallia.vault.core.vault.player.ClassicListenersLogic;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.vault.time.TickTimer;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.world.vault.modifier.VaultModifierStack;
import iskallia.vault.world.vault.modifier.modifier.PlayerInventoryRestoreModifier;
import iskallia.vault.world.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.Direction;

public class VaultFactory {
    public static Vault create(Version version, CrystalData crystal, boolean casual) {
        CrystalLayout layout;
        int level = Math.max(crystal.getLevel(), 0);
        long seed = new Random().nextLong();
        JavaRandom random = JavaRandom.ofScrambled(seed);
        Vault vault = new Vault();
        ((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)vault.set(Vault.ID, UUID.randomUUID())).set(Vault.VERSION, version)).set(Vault.SEED, seed)).set(Vault.LEVEL, (VaultLevel)new VaultLevel().set(VaultLevel.VALUE, level))).set(Vault.CLOCK, (TickClock)new TickTimer().set(TickTimer.DISPLAY_TIME, 30000))).set(Vault.WORLD, (WorldManager)((WorldManager)((WorldManager)((WorldManager)((WorldManager)((WorldManager)((WorldManager)new WorldManager().set(WorldManager.FACING, Direction.m_122407_((int)random.nextInt(4)))).set(WorldManager.RANDOM_TICK_SPEED, 0)).set(WorldManager.LOOT_LOGIC, (LootLogic)new ClassicLootLogic().setIf(ClassicLootLogic.ADD_CATALYST_FRAGMENTS, () -> !crystal.preventsRandomModifiers()))).set(WorldManager.PORTAL_LOGIC, new ClassicPortalLogic())).set(WorldManager.MOB_LOGIC, new ClassicMobLogic())).set(WorldManager.GENERATOR, (VaultGenerator)((VaultGenerator)new GridGenerator().set(GridGenerator.CELL_X, 47)).set(GridGenerator.CELL_Z, 47))).set(WorldManager.RENDERER, new WorldRenderer()))).set(Vault.OVERLAY, new VaultOverlay())).set(Vault.OBJECTIVES, new Objectives())).set(Vault.MODIFIERS, new Modifiers())).set(Vault.LISTENERS, (Listeners)new Listeners().set(Listeners.LOGIC, new ClassicListenersLogic()))).set(Vault.INFLUENCES, new Influences())).set(Vault.STATS, new StatsCollector())).set(Vault.CRYSTAL, crystal.serializeNBT());
        CrystalLayout crystalLayout = layout = crystal.getLayout() == null ? (CrystalLayout)ModConfigs.VAULT_CRYSTAL.getRandomLayout(level, random).orElse(null) : crystal.getLayout();
        if (layout != null) {
            layout.configure(vault);
        }
        if (crystal.getTheme() != null) {
            crystal.getTheme().configure(vault, random);
        }
        vault.ifPresent(Vault.OBJECTIVES, objectives -> {
            if (crystal.getObjective() != null) {
                objectives.set(Objectives.KEY, CrystalObjective.getId(crystal.getObjective()));
                crystal.getObjective().configure(vault, random);
                return;
            }
            ModConfigs.VAULT_CRYSTAL.getRandomObjective(level, random).ifPresentOrElse(objective -> {
                objectives.set(Objectives.KEY, CrystalObjective.getId(objective));
                objective.configure(vault, random);
            }, () -> objectives.add(VictoryObjective.of(300)));
        });
        for (VaultModifierStack stack : crystal.getModifiers()) {
            vault.ifPresent(Vault.MODIFIERS, m -> m.addPermanentModifier(stack.getModifier(), stack.getSize(), true));
        }
        if (casual) {
            vault.ifPresent(Vault.MODIFIERS, m -> m.addPermanentModifier(VaultModifierRegistry.getOrDefault(VaultMod.id("phoenix"), null), 1, false));
        }
        if (!crystal.preventsRandomModifiers()) {
            List<VaultModifier<?>> modifiers = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(VaultMod.id("default"), vault.get(Vault.LEVEL).get(), random);
            for (VaultModifier<?> modifier : modifiers) {
                if (casual && modifier instanceof PlayerInventoryRestoreModifier) continue;
                vault.ifPresent(Vault.MODIFIERS, m -> m.addPermanentModifier(modifier, 1, true));
            }
        }
        return vault;
    }
}

