/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.key.registry.ISupplierKey;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.influence.Influences;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.overlay.VaultOverlay;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.world.vault.modifier.modifier.GameControlsModifier;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class Vault
extends DataObject<Vault> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<Version> VERSION = (FieldKey)FieldKey.of("version", Version.class).with(Version.v1_0, Adapter.ofEnum(Version.class), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<UUID> ID = (FieldKey)FieldKey.of("id", UUID.class).with(Version.v1_0, Adapter.ofUUID(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Long> SEED = (FieldKey)FieldKey.of("seed", Long.class).with(Version.v1_0, Adapter.ofLong(), DISK.all()).register(FIELDS);
    public static final FieldKey<UUID> OWNER = (FieldKey)FieldKey.of("owner", UUID.class).with(Version.v1_0, Adapter.ofUUID(), DISK.all()).register(FIELDS);
    public static final FieldKey<VaultLevel> LEVEL = (FieldKey)FieldKey.of("level", VaultLevel.class).with(Version.v1_0, Adapter.ofCompound(VaultLevel::new), DISK.all()).register(FIELDS);
    public static final FieldKey<TickClock> CLOCK = (FieldKey)FieldKey.of("clock", TickClock.class).with(Version.v1_0, Adapter.ofRegistryValue(() -> VaultRegistry.CLOCK, ISupplierKey::getKey, Supplier::get), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<WorldManager> WORLD = (FieldKey)FieldKey.of("world_manager", WorldManager.class).with(Version.v1_0, Adapter.ofCompound(WorldManager::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<VaultOverlay> OVERLAY = (FieldKey)FieldKey.of("overlay", VaultOverlay.class).with(Version.v1_0, Adapter.ofCompound(VaultOverlay::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Void> FINISHED = (FieldKey)FieldKey.of("finished", Void.class).with(Version.v1_0, Adapter.ofVoid(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Listeners> LISTENERS = (FieldKey)FieldKey.of("listeners", Listeners.class).with(Version.v1_0, Adapter.ofCompound(), DISK.all().or(CLIENT.all()), Listeners::new).register(FIELDS);
    public static final FieldKey<Objectives> OBJECTIVES = (FieldKey)FieldKey.of("objectives", Objectives.class).with(Version.v1_0, Adapter.ofCompound(), DISK.all().or(CLIENT.all()), Objectives::new).register(FIELDS);
    public static final FieldKey<Modifiers> MODIFIERS = (FieldKey)FieldKey.of("modifiers", Modifiers.class).with(Version.v1_0, Adapter.ofCompound(), DISK.all().or(CLIENT.all()), Modifiers::new).register(FIELDS);
    public static final FieldKey<Influences> INFLUENCES = (FieldKey)FieldKey.of("influences", Influences.class).with(Version.v1_0, Adapter.ofCompound(), DISK.all().or(CLIENT.all()), Influences::new).register(FIELDS);
    public static final FieldKey<StatsCollector> STATS = (FieldKey)FieldKey.of("stats", StatsCollector.class).with(Version.v1_0, Adapter.ofCompound(), DISK.all(), StatsCollector::new).register(FIELDS);
    public static final FieldKey<CompoundTag> CRYSTAL = (FieldKey)FieldKey.of("crystal", CompoundTag.class).with(Version.v1_2, Adapter.ofNBT(CompoundTag.class), DISK.all()).register(FIELDS);

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initServer(VirtualWorld world) {
        CommonEvents.SERVER_TICK.at(TickEvent.Phase.END).register(this, data -> this.tickServer(world));
        this.ifPresent(WORLD, worldSettings -> worldSettings.initServer(world, this));
        this.ifPresent(OBJECTIVES, objectives -> objectives.initServer(world, this));
        this.ifPresent(MODIFIERS, modifiers -> modifiers.initServer(world, this));
        this.ifPresent(LISTENERS, listeners -> listeners.initServer(world, this));
        this.ifPresent(INFLUENCES, influences -> influences.initServer(world, this));
        this.ifPresent(STATS, stats -> stats.initServer(world, this));
    }

    protected void tickServer(VirtualWorld world) {
        this.ifPresent(WORLD, worldSettings -> worldSettings.tickServer(world, this));
        this.ifPresent(OBJECTIVES, objectives -> objectives.tickServer(world, this));
        this.ifPresent(CLOCK, clock -> clock.tickServer(world));
        this.ifPresent(MODIFIERS, modifiers -> modifiers.tickServer(world, this));
        this.ifPresent(LISTENERS, listeners -> listeners.tickServer(world, this));
        this.ifPresent(INFLUENCES, influences -> influences.tickServer(world, this));
    }

    public void releaseServer() {
        CommonEvents.release(this);
        this.ifPresent(WORLD, WorldManager::releaseServer);
        this.ifPresent(OBJECTIVES, Objectives::releaseServer);
        this.ifPresent(MODIFIERS, Modifiers::releaseServer);
        this.ifPresent(LISTENERS, Listeners::releaseServer);
        this.ifPresent(INFLUENCES, Influences::releaseServer);
        this.ifPresent(STATS, StatsCollector::releaseServer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        ClientEvents.CLIENT_TICK.at(TickEvent.Phase.END).register(this, data -> this.tickClient());
        this.ifPresent(WORLD, worldManager -> worldManager.initClient(this));
        this.ifPresent(OVERLAY, overlay -> overlay.initClient(this));
        this.get(MODIFIERS).getModifiers().stream().filter(m -> m instanceof GameControlsModifier).forEach(m -> {
            GameControlsModifier.Properties currentProps;
            GameControlsModifier modifier = (GameControlsModifier)m;
            currentProps.setForward((currentProps = ClientVaults.CONTROLS_PROPERTIES).canMoveForward() && ((GameControlsModifier.Properties)modifier.properties()).canMoveForward());
            currentProps.setBackward(currentProps.canMoveBackward() && ((GameControlsModifier.Properties)modifier.properties()).canMoveBackward());
            currentProps.setJump(currentProps.canJump() && ((GameControlsModifier.Properties)modifier.properties()).canJump());
            currentProps.setSwapLeftAndRight(currentProps.isLeftAndRightSwapped() || ((GameControlsModifier.Properties)modifier.properties()).isLeftAndRightSwapped());
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient() {
        this.ifPresent(CLOCK, TickClock::tickClient);
        if (this.has(FINISHED)) {
            this.releaseClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void releaseClient() {
        CommonEvents.release(this);
        ClientEvents.release(this);
        ClientVaults.ACTIVE = new Vault();
        ClientVaults.CONTROLS_PROPERTIES = new GameControlsModifier.Properties(true, true, true, false);
    }
}

