/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataList;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.adapter.DirectAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.world.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.world.vault.modifier.spi.ModifierContext;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Modifiers
extends DataObject<Modifiers> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    private static final FieldKey<Entry.List> ENTRIES = (FieldKey)FieldKey.of("entries", Entry.List.class).with(Version.v1_0, Adapter.ofCompound(), DISK.all().or(CLIENT.all()), Entry.List::new).register(FIELDS);

    public Modifiers() {
        this.set(ENTRIES, new Entry.List());
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public Modifiers addPermanentModifier(VaultModifier<?> modifier, int amount, boolean display) {
        for (int i = 0; i < amount; ++i) {
            this.get(ENTRIES).add(new Entry(modifier, display));
        }
        return this;
    }

    public Modifiers addTemporaryModifier(VaultModifier<?> modifier, int amount, int timeLeft, boolean display) {
        for (int i = 0; i < amount; ++i) {
            this.get(ENTRIES).add(new Entry(modifier, timeLeft, display));
        }
        return this;
    }

    public List<VaultModifier<?>> getModifiers() {
        ArrayList modifiers = new ArrayList();
        for (Entry entry : this.get(ENTRIES)) {
            if (!entry.has(Entry.MODIFIER)) continue;
            modifiers.add(entry.get(Entry.MODIFIER));
        }
        return modifiers;
    }

    public void onListenerAdd(VirtualWorld world, Vault vault, Listener listener) {
        for (Entry entry : this.get(ENTRIES)) {
            entry.get(Entry.MODIFIER).onListenerAdd(world, vault, entry.get(Entry.CONTEXT), listener);
        }
    }

    public void onListenerRemove(VirtualWorld world, Vault vault, Listener listener) {
        for (Entry entry : this.get(ENTRIES)) {
            entry.get(Entry.MODIFIER).onListenerRemove(world, vault, entry.get(Entry.CONTEXT), listener);
        }
    }

    public Object2IntMap<VaultModifier<?>> getDisplayGroup() {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (Entry entry : this.get(ENTRIES)) {
            if (!entry.has(Entry.DISPLAY)) continue;
            VaultModifier modifier = entry.get(Entry.MODIFIER);
            map.put((Object)modifier, map.getOrDefault((Object)modifier, 0) + 1);
        }
        return map;
    }

    public void initServer(VirtualWorld world, Vault vault) {
        for (Entry entry : this.get(ENTRIES)) {
            if (entry.has(Entry.CONSUMED)) {
                entry.get(Entry.MODIFIER).initServer(world, vault, entry.get(Entry.CONTEXT));
                return;
            }
            entry.get(Entry.MODIFIER).onVaultAdd(world, vault, entry.get(Entry.CONTEXT));
            vault.ifPresent(Vault.LISTENERS, listeners -> {
                for (Listener listener : listeners.getAll()) {
                    entry.get(Entry.MODIFIER).onListenerAdd(world, vault, entry.get(Entry.CONTEXT), listener);
                }
            });
            entry.set(Entry.CONSUMED);
        }
    }

    public void tickServer(VirtualWorld world, Vault vault) {
        this.get(ENTRIES).removeIf(entry -> {
            if (!entry.hasExpired()) {
                return false;
            }
            if (!entry.has(Entry.CONSUMED)) {
                return true;
            }
            entry.get(Entry.MODIFIER).onVaultRemove(world, vault, entry.get(Entry.CONTEXT));
            vault.ifPresent(Vault.LISTENERS, listeners -> {
                for (Listener listener : listeners.getAll()) {
                    entry.get(Entry.MODIFIER).onListenerRemove(world, vault, entry.get(Entry.CONTEXT), listener);
                }
            });
            return true;
        });
        this.get(ENTRIES).forEach(entry -> {
            if (entry.has(Entry.CONSUMED)) {
                return;
            }
            entry.get(Entry.MODIFIER).onVaultAdd(world, vault, entry.get(Entry.CONTEXT));
            vault.ifPresent(Vault.LISTENERS, listeners -> {
                for (Listener listener : listeners.getAll()) {
                    entry.get(Entry.MODIFIER).onListenerAdd(world, vault, entry.get(Entry.CONTEXT), listener);
                }
            });
            entry.set(Entry.CONSUMED);
        });
        this.get(ENTRIES).forEach(Entry::tick);
    }

    public void releaseServer() {
        this.get(ENTRIES).forEach(entry -> entry.get(Entry.MODIFIER).releaseServer(entry.get(Entry.CONTEXT)));
    }

    private static class Entry
    extends DataObject<Entry> {
        public static final FieldRegistry FIELDS = new FieldRegistry();
        public static final FieldKey<VaultModifier> MODIFIER = (FieldKey)FieldKey.of("modifier", VaultModifier.class).with(Version.v1_0, new DirectAdapter<VaultModifier>((buffer, context, value) -> buffer.writeIdentifier(value.getId()), (buffer, context) -> (VaultModifier)VaultModifierRegistry.getOpt(buffer.readIdentifier()).orElseThrow()), DISK.all().or(CLIENT.all())).register(FIELDS);
        public static final FieldKey<ModifierContext> CONTEXT = (FieldKey)FieldKey.of("context", ModifierContext.class).with(Version.v1_0, Adapter.ofCompound(ModifierContext::new), DISK.all().or(CLIENT.all())).register(FIELDS);
        public static final FieldKey<Void> DISPLAY = (FieldKey)FieldKey.of("display", Void.class).with(Version.v1_0, Adapter.ofVoid(), DISK.all().or(CLIENT.all())).register(FIELDS);
        public static final FieldKey<Void> CONSUMED = (FieldKey)FieldKey.of("consumed", Void.class).with(Version.v1_0, Adapter.ofVoid(), DISK.all().or(CLIENT.all())).register(FIELDS);

        private Entry() {
        }

        public Entry(VaultModifier<?> modifier, boolean display) {
            this.set(MODIFIER, modifier);
            this.set(CONTEXT, (ModifierContext)new ModifierContext().set(ModifierContext.UUID, UUID.randomUUID()));
            this.setIf(DISPLAY, () -> display);
        }

        public Entry(VaultModifier<?> modifier, int timeLeft, boolean display) {
            this.set(MODIFIER, modifier);
            this.set(CONTEXT, (ModifierContext)((ModifierContext)new ModifierContext().set(ModifierContext.UUID, UUID.randomUUID())).set(ModifierContext.TICKS_LEFT, timeLeft));
            this.setIf(DISPLAY, () -> display);
        }

        @Override
        public FieldRegistry getFields() {
            return FIELDS;
        }

        public boolean hasExpired() {
            return this.get(CONTEXT).hasExpired();
        }

        public void tick() {
            if (this.get(CONTEXT).has(ModifierContext.TICKS_LEFT)) {
                this.get(CONTEXT).modify(ModifierContext.TICKS_LEFT, i -> i - 1);
            }
        }

        private static class List
        extends DataList<List, Entry> {
            public List() {
                super(new ArrayList(), Adapter.ofCompound(Entry::new));
            }
        }
    }
}

