/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.key.registry.ISupplierKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.ChestGenerationEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.storage.VirtualWorld;

public abstract class LootLogic
extends DataObject<LootLogic>
implements ISupplierKey<LootLogic> {
    public static final FieldRegistry FIELDS = new FieldRegistry();

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.CHEST_LOOT_GENERATION.pre().register(vault, data -> {
            if (data.getTileEntity().m_58904_() != world) {
                return;
            }
            JavaRandom random = JavaRandom.ofInternal(vault.get(Vault.SEED));
            long a = random.nextLong() | 1L;
            long b = random.nextLong() | 1L;
            long c = random.nextLong() | 1L;
            int x = data.getPos().m_123341_();
            int y = data.getPos().m_123342_();
            int z = data.getPos().m_123343_();
            random.setSeed(a * (long)x + b * (long)y + c + (long)z ^ vault.get(Vault.SEED));
            data.setRandom(random);
            this.onPreGenerate(world, vault, (ChestGenerationEvent.Data)data);
        });
        CommonEvents.CHEST_LOOT_GENERATION.post().register(vault, data -> {
            if (data.getTileEntity().m_58904_() != world) {
                return;
            }
            this.onPostGenerate(world, vault, (ChestGenerationEvent.Data)data);
        });
    }

    protected abstract void onPreGenerate(VirtualWorld var1, Vault var2, ChestGenerationEvent.Data var3);

    protected abstract void onPostGenerate(VirtualWorld var1, Vault var2, ChestGenerationEvent.Data var3);
}

