/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.util;

import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.random.RandomGenerator;

public class WeightedTree<T> {
    private final WeightedList<Object> children = new WeightedList();

    public WeightedList<Object> getChildren() {
        return this.children;
    }

    public WeightedList<T> flatten() {
        return null;
    }

    public WeightedTree<T> addLeaf(T value, int weight) {
        this.children.add(value, weight);
        return this;
    }

    public WeightedTree<T> addTree(WeightedTree<T> tree, int weight) {
        this.children.add(tree, weight);
        return this;
    }

    public WeightedTree<T> addTree(Consumer<WeightedTree<T>> root, int weight) {
        WeightedTree<T> tree = new WeightedTree<T>();
        this.children.add(tree, weight);
        root.accept(tree);
        return this;
    }

    public Optional<T> getRandom() {
        return this.getRandom(new Random());
    }

    public Optional<T> getRandom(RandomGenerator random) {
        return this.getRandom(random::nextInt);
    }

    public Optional<T> getRandom(RandomSource random) {
        return this.getRandom(random::nextInt);
    }

    public Optional<T> getRandom(IntUnaryOperator random) {
        Optional<Object> opt = this.children.getRandom(random);
        if (opt.isEmpty()) {
            return Optional.empty();
        }
        Object value = opt.get();
        return value instanceof WeightedTree ? ((WeightedTree)value).getRandom(random) : opt;
    }

    public Optional<T> getRandom(IntUnaryOperator random, BiConsumer<WeightedList<Object>, Object> step) {
        Optional<Object> opt = this.children.getRandom(random);
        if (opt.isEmpty()) {
            return Optional.empty();
        }
        Object value = opt.get();
        step.accept(this.children, value);
        return value instanceof WeightedTree ? ((WeightedTree)value).getRandom(random) : opt;
    }

    public void iterate(Predicate<T> action) {
        this.iterate(this, action);
    }

    protected boolean iterate(Object node, Predicate<T> action) {
        if (node instanceof WeightedTree) {
            WeightedTree tree = (WeightedTree)node;
            for (Object child : tree.children.keySet()) {
                if (this.iterate(child, action)) continue;
                return false;
            }
        } else {
            return action.test(node);
        }
        return true;
    }
}

