/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;

public class RegionPos
extends Vec3i {
    private final int sizeX;
    private final int sizeZ;

    protected RegionPos(int x, int z, int sizeX, int sizeZ) {
        super(x, 0, z);
        this.sizeX = sizeX;
        this.sizeZ = sizeZ;
    }

    public static RegionPos of(int x, int z, int sizeX, int sizeZ) {
        return new RegionPos(x, z, sizeX, sizeZ);
    }

    public static RegionPos ofChunkPos(ChunkPos chunkPos, int sizeX, int sizeY) {
        int x = chunkPos.f_45578_ < 0 ? chunkPos.f_45578_ - sizeX + 1 : chunkPos.f_45578_;
        int z = chunkPos.f_45579_ < 0 ? chunkPos.f_45579_ - sizeY + 1 : chunkPos.f_45579_;
        return new RegionPos(x / sizeX, z / sizeY, sizeX, sizeY);
    }

    public static RegionPos ofBlockPos(BlockPos blockPos, int sizeX, int sizeZ) {
        int x = blockPos.m_123341_() < 0 ? blockPos.m_123341_() - sizeX + 1 : blockPos.m_123341_();
        int z = blockPos.m_123343_() < 0 ? blockPos.m_123343_() - sizeZ + 1 : blockPos.m_123343_();
        return new RegionPos(x / sizeX, z / sizeZ, sizeX, sizeZ);
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }

    public RegionPos with(int x, int z) {
        return new RegionPos(x, z, this.sizeX, this.sizeZ);
    }

    public BlockPos getLocalPos(BlockPos blockPos) {
        return new BlockPos(blockPos.m_123341_() % this.sizeX, blockPos.m_123342_(), blockPos.m_123343_() % this.sizeX);
    }

    public ChunkPos getLocalPos(ChunkPos chunkPos) {
        return new ChunkPos(chunkPos.f_45578_ % this.sizeX, chunkPos.f_45579_ % this.sizeX);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.m_123341_() * this.getSizeX(), 0, this.m_123343_() * this.getSizeX());
    }

    public ChunkPos toChunkPos() {
        return new ChunkPos(this.m_123341_() * this.getSizeX(), this.m_123343_() * this.getSizeX());
    }

    public RegionPos add(int x, int z) {
        return new RegionPos(this.m_123341_() + x, this.m_123343_() + z, this.sizeX, this.sizeZ);
    }
}

