/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.random;

import iskallia.vault.core.random.LCGRandom;
import iskallia.vault.core.random.lcg.LCG;
import java.util.Random;

public class JavaRandom
extends LCGRandom {
    public static final long MULTIPLIER = LCG.JAVA.multiplier;
    public static final long ADDEND = LCG.JAVA.addend;
    public static final long MASK = LCG.JAVA.modulus - 1L;
    protected double nextNextGaussian;
    protected boolean haveNextNextGaussian;

    protected JavaRandom(long seed) {
        super(LCG.JAVA, seed);
    }

    public static JavaRandom ofInternal(long seed) {
        return new JavaRandom(seed);
    }

    public static JavaRandom ofScrambled(long seed) {
        return new JavaRandom(seed ^ MULTIPLIER);
    }

    public static JavaRandom ofNanoTime() {
        return new JavaRandom(new Random().nextLong());
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed ^ MULTIPLIER);
    }

    public int next(int bits) {
        return (int)(this.nextSeed() >>> 48 - bits);
    }

    @Override
    public long nextSeed() {
        this.seed = this.seed * MULTIPLIER + ADDEND & MASK;
        return this.seed;
    }

    @Override
    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    @Override
    public int nextInt() {
        return this.next(32);
    }

    @Override
    public int nextInt(int bound) {
        int value;
        int bits;
        if (bound <= 0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        if ((bound & -bound) == bound) {
            return (int)((long)bound * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (value = bits % bound) + (bound - 1) < 0) {
        }
        return value;
    }

    @Override
    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    @Override
    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) * (double)1.110223E-16f;
    }

    @Override
    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public Random toRandom() {
        return new Random(this.seed ^ MULTIPLIER);
    }

    public Random asRandomView() {
        return new View(this);
    }

    public JavaRandom copy() {
        JavaRandom copy = new JavaRandom(this.seed);
        copy.haveNextNextGaussian = this.haveNextNextGaussian;
        copy.nextNextGaussian = this.nextNextGaussian;
        return copy;
    }

    protected static class View
    extends Random {
        private final JavaRandom delegate;

        protected View(JavaRandom delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setSeed(long seed) {
            if (this.delegate != null) {
                this.delegate.setSeed(seed);
            }
        }

        @Override
        protected int next(int bits) {
            return this.delegate.next(bits);
        }

        @Override
        public double nextGaussian() {
            return this.delegate.nextGaussian();
        }
    }
}

