/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.key.registry;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.VersionedKey;
import iskallia.vault.core.random.RandomSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;

public class KeyRegistry<K extends VersionedKey<? extends K, ? extends T>, T> {
    protected List<K> keys = new ArrayList<K>();
    protected Map<Version, List<K>> keyCache = new HashMap<Version, List<K>>();
    protected Map<Version, Map<ResourceLocation, Integer>> indexCache = new HashMap<Version, Map<ResourceLocation, Integer>>();
    protected Map<ResourceLocation, K> idCache = new HashMap<ResourceLocation, K>();
    protected boolean locked = false;

    public KeyRegistry() {
    }

    public KeyRegistry(K ... keys) {
        for (K key : keys) {
            this.register(key);
        }
        this.locked = true;
    }

    public <R extends KeyRegistry<K, T>> R merge(R other) {
        this.keys.forEach(other::register);
        return other;
    }

    public void lock() {
        this.locked = true;
    }

    public boolean contains(K key) {
        return this.idCache.get(((VersionedKey)key).getId()) != null;
    }

    public K getRandom(RandomSource random, Predicate<K> filter) {
        int size = 1;
        VersionedKey result = null;
        for (VersionedKey key : this.keys) {
            if (!filter.test(key) || random.nextInt(size++) != 0) continue;
            result = key;
        }
        return (K)result;
    }

    public K register(K key) {
        if (this.locked) {
            throw new UnsupportedOperationException("Registry is locked");
        }
        this.idCache.put(((VersionedKey)key).getId(), (ResourceLocation)key);
        this.keys.add(key);
        this.keys.sort(Comparator.comparing(VersionedKey::getId));
        return key;
    }

    public void remove(K key) {
        this.idCache.remove(((VersionedKey)key).getId());
        this.keys.remove(key);
        this.keyCache.clear();
        this.indexCache.clear();
    }

    public K getKey(String id) {
        return id == null ? null : (K)this.getKey(new ResourceLocation(id));
    }

    public K getKey(ResourceLocation id) {
        return (K)(id == null ? null : (VersionedKey)this.idCache.get(id));
    }

    public List<K> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public int getIndex(ResourceLocation id, Version version) {
        return this.getIndex(this.getKey(id), version);
    }

    public int getIndex(K key, Version version) {
        this.ensureCacheIsPresent(version);
        return this.indexCache.get((Object)version).getOrDefault(((VersionedKey)key).getId(), -1);
    }

    public K getKey(int index, Version version) {
        this.ensureCacheIsPresent(version);
        return (K)((VersionedKey)this.keyCache.get((Object)version).get(index));
    }

    public int getSize(Version version) {
        this.ensureCacheIsPresent(version);
        return this.keyCache.get((Object)version).size();
    }

    private void ensureCacheIsPresent(Version version) {
        if (this.keyCache.containsKey((Object)version)) {
            return;
        }
        ArrayList<VersionedKey> keys = new ArrayList<VersionedKey>();
        HashMap<ResourceLocation, Integer> indices = new HashMap<ResourceLocation, Integer>();
        int index = 0;
        for (int i = 0; i < this.keys.size(); ++i) {
            VersionedKey key = (VersionedKey)this.keys.get(i);
            if (!key.supports(version)) continue;
            keys.add(key);
            indices.put(key.getId(), index++);
        }
        this.keyCache.put(version, keys);
        this.indexCache.put(version, indices);
    }
}

