/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.key;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.Keyed;
import iskallia.vault.core.data.key.registry.KeyRegistry;
import iskallia.vault.core.util.VersionMap;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;

public class VersionedKey<K extends VersionedKey<K, T>, T> {
    protected ResourceLocation id;
    protected VersionMap<T> entries = new VersionMap();

    protected VersionedKey(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public VersionMap<T> getMap() {
        return this.entries;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public T get(Version version) {
        return this.entries.getFor(version).orElseThrow(IllegalStateException::new);
    }

    public boolean supports(Version version) {
        Optional<Version> opt = this.entries.getOldest();
        if (opt.isEmpty()) {
            return false;
        }
        return version.isNewerOrEqualTo(opt.get());
    }

    public K with(Version version, T value) {
        this.entries.put(version, value);
        if (value instanceof Keyed) {
            Keyed keyedValue = (Keyed)value;
            keyedValue.setKey(this);
        }
        return (K)this;
    }

    public K withMap(Version version, UnaryOperator<T> value) {
        Object previous = this.entries.getFor(version).orElse(null);
        return this.with(version, value.apply(previous));
    }

    public <R extends KeyRegistry<? super K, ? super T>> K register(R registry) {
        registry.register((VersionedKey)this);
        return (K)this;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id.toString();
    }
}

