/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter;

import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.sync.context.SyncContext;
import iskallia.vault.core.net.BitBuffer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ResourceKeyAdapter<T>
extends Adapter<ResourceKey<T>> {
    private final ResourceKey<Registry<T>> registry;
    private final boolean nullable;

    public ResourceKeyAdapter(ResourceKey<Registry<T>> registry, boolean nullable) {
        this.registry = registry;
        this.nullable = nullable;
    }

    public ResourceKeyAdapter<T> asNullable() {
        return this.nullable ? this : new ResourceKeyAdapter<T>(this.registry, true);
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public ResourceKey<T> validate(ResourceKey<T> value, SyncContext context) {
        if (!this.nullable && value == null) {
            throw new UnsupportedOperationException("Value cannot be null");
        }
        return value;
    }

    @Override
    public void writeValue(BitBuffer buffer, SyncContext context, ResourceKey<T> value) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeIdentifier(value.m_135782_());
        }
    }

    @Override
    public ResourceKey<T> readValue(BitBuffer buffer, SyncContext context, ResourceKey<T> value) {
        if (this.nullable && buffer.readBoolean()) {
            return null;
        }
        return ResourceKey.m_135785_(this.registry, (ResourceLocation)buffer.readIdentifier());
    }
}

