/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter;

import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.sync.context.SyncContext;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagTypes;
import org.jetbrains.annotations.NotNull;

public class NBTAdapter<T extends Tag>
extends Adapter<T> {
    private final Class<T> type;
    private final boolean nullable;

    public NBTAdapter(Class<T> type, boolean nullable) {
        this.type = type;
        this.nullable = nullable;
    }

    public NBTAdapter<T> asNullable() {
        return this.nullable ? this : new NBTAdapter<T>(this.type, true);
    }

    @Override
    public T validate(T value, SyncContext context) {
        if (!this.nullable && value == null) {
            throw new UnsupportedOperationException("Value cannot be null");
        }
        return value;
    }

    @Override
    public void writeValue(BitBuffer buffer, SyncContext context, T value) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            try {
                Interface output = new Interface(buffer);
                output.writeByte(value.m_7060_());
                if (value.m_7060_() != 0) {
                    output.writeUTF("");
                    value.m_6434_((DataOutput)output);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public T readValue(BitBuffer buffer, SyncContext context, T value) {
        if (this.nullable && buffer.readBoolean()) {
            return null;
        }
        try {
            Interface input = new Interface(buffer);
            NbtAccounter accounter = NbtAccounter.f_128917_;
            byte type = input.readByte();
            if (type == 0) {
                return (T)EndTag.f_128534_;
            }
            NbtAccounter.f_128917_.readUTF(input.readUTF());
            try {
                return (T)TagTypes.m_129397_((int)type).m_7300_((DataInput)input, 0, accounter);
            }
            catch (IOException e1) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)e1, (String)"Loading NBT data");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("NBT Tag");
                crashreportcategory.m_128159_("Tag type", (Object)type);
                throw new ReportedException(crashreport);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static class Interface
    implements DataInput,
    DataOutput {
        private final BitBuffer parent;

        public Interface(BitBuffer parent) {
            this.parent = parent;
        }

        @Override
        public void readFully(byte @NotNull [] bytes) throws IOException {
            this.parent.readBytes(bytes);
        }

        @Override
        public void readFully(byte @NotNull [] bytes, int off, int len) throws IOException {
            this.parent.readBytes(bytes, off, len);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            for (int i = 0; i < n; ++i) {
                this.parent.readByte();
            }
            return n;
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.parent.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            return this.parent.readByte();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.parent.readIntBits(8);
        }

        @Override
        public short readShort() throws IOException {
            return this.parent.readShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.parent.readIntBits(16);
        }

        @Override
        public char readChar() throws IOException {
            return this.parent.readChar();
        }

        @Override
        public int readInt() throws IOException {
            return this.parent.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.parent.readLong();
        }

        @Override
        public float readFloat() throws IOException {
            return this.parent.readFloat();
        }

        @Override
        public double readDouble() throws IOException {
            return this.parent.readDouble();
        }

        @Override
        public String readLine() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String readUTF() throws IOException {
            int c;
            int bytesSize;
            int size = this.parent.readIntBits(8) << 8 | this.parent.readIntBits(8);
            byte[] bytes = new byte[size];
            char[] chars = new char[size];
            int charsSize = 0;
            this.readFully(bytes, 0, size);
            for (bytesSize = 0; bytesSize < size && (c = bytes[bytesSize] & 0xFF) <= 127; ++bytesSize) {
                chars[charsSize++] = (char)c;
            }
            block6: while (bytesSize < size) {
                c = bytes[bytesSize] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++bytesSize;
                        chars[charsSize++] = (char)c;
                        continue block6;
                    }
                    case 12: 
                    case 13: {
                        if ((bytesSize += 2) > size) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = bytes[bytesSize - 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + bytesSize);
                        }
                        chars[charsSize++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        continue block6;
                    }
                    case 14: {
                        if ((bytesSize += 3) > size) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = bytes[bytesSize - 2];
                        byte char3 = bytes[bytesSize - 1];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + (bytesSize - 1));
                        }
                        chars[charsSize++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        continue block6;
                    }
                }
                throw new UTFDataFormatException("malformed input around byte " + bytesSize);
            }
            return new String(chars, 0, charsSize);
        }

        @Override
        public void write(int b) throws IOException {
            this.parent.writeIntBits(b, 8);
        }

        @Override
        public void write(byte @NotNull [] bytes) throws IOException {
            this.parent.writeBytes(bytes);
        }

        @Override
        public void write(byte @NotNull [] bytes, int off, int len) throws IOException {
            this.parent.writeBytes(bytes, off, len);
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.parent.writeBoolean(v);
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.parent.writeByte((byte)v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.parent.writeShort((short)v);
        }

        @Override
        public void writeChar(int v) throws IOException {
            this.parent.writeChar((char)v);
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.parent.writeInt(v);
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.parent.writeLong(v);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.parent.writeFloat(v);
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.parent.writeDouble(v);
        }

        @Override
        public void writeBytes(@NotNull String s) throws IOException {
            for (int i = 0; i < s.length(); ++i) {
                this.parent.writeByte((byte)s.charAt(i));
            }
        }

        @Override
        public void writeChars(@NotNull String s) throws IOException {
            for (int i = 0; i < s.length(); ++i) {
                char v = s.charAt(i);
                this.parent.writeByte((byte)(v >>> 8));
                this.parent.writeByte((byte)v);
            }
        }

        @Override
        public void writeUTF(@NotNull String s) throws IOException {
            char c;
            int i;
            int size;
            int utfSize = size = s.length();
            for (int i2 = 0; i2 < size; ++i2) {
                char c2 = s.charAt(i2);
                if (c2 < '\u0080' && c2 != '\u0000') continue;
                utfSize += c2 >= '\u0800' ? 2 : 1;
            }
            if (utfSize > 65535 || utfSize < size) {
                throw new UTFDataFormatException(Interface.tooLongMsg(s, utfSize));
            }
            byte[] bytes = new byte[utfSize + 2];
            int count = 0;
            bytes[count++] = (byte)(utfSize >>> 8 & 0xFF);
            bytes[count++] = (byte)(utfSize & 0xFF);
            for (i = 0; i < size && (c = s.charAt(i)) < '\u0080' && c != '\u0000'; ++i) {
                bytes[count++] = (byte)c;
            }
            while (i < size) {
                c = s.charAt(i);
                if (c < '\u0080' && c != '\u0000') {
                    bytes[count++] = (byte)c;
                } else if (c >= '\u0800') {
                    bytes[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                    bytes[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                    bytes[count++] = (byte)(0x80 | c & 0x3F);
                } else {
                    bytes[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    bytes[count++] = (byte)(0x80 | c & 0x3F);
                }
                ++i;
            }
            this.parent.writeBytes(bytes, 0, utfSize + 2);
        }

        private static String tooLongMsg(String s, int bits32) {
            int slen = s.length();
            String head = s.substring(0, 8);
            String tail = s.substring(slen - 8, slen);
            long actualLength = (long)slen + Integer.toUnsignedLong(bits32 - slen);
            return "encoded string (" + head + "..." + tail + ") too long: " + actualLength + " bytes";
        }
    }
}

