/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter;

import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.adapter.IdentifierAdapter;
import iskallia.vault.core.data.adapter.NBTAdapter;
import iskallia.vault.core.data.sync.context.SyncContext;
import iskallia.vault.core.net.BitBuffer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemStackAdapter
extends Adapter<ItemStack> {
    public static final IdentifierAdapter ITEM = Adapter.ofIdentifier().asNullable();
    public static final NBTAdapter<CompoundTag> TAG = Adapter.ofNBT(CompoundTag.class).asNullable();

    @Override
    public ItemStack validate(ItemStack value, SyncContext context) {
        if (value == null) {
            throw new UnsupportedOperationException("Value cannot be null");
        }
        return value;
    }

    @Override
    public void writeValue(BitBuffer buffer, SyncContext context, ItemStack value) {
        buffer.writeBoolean(value.m_41619_());
        if (!value.m_41619_()) {
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)value.m_41720_());
            ITEM.writeValue(buffer, context, id);
            buffer.writeIntSegmented(value.m_41613_(), 7);
            TAG.writeValue(buffer, context, value.m_41783_());
            CompoundTag caps = value.m_41739_(new CompoundTag()).m_128469_("ForgeCaps");
            TAG.writeValue(buffer, context, caps.m_128456_() ? null : caps);
        }
    }

    @Override
    public ItemStack readValue(BitBuffer buffer, SyncContext context, ItemStack value) {
        if (buffer.readBoolean()) {
            return ItemStack.f_41583_;
        }
        ResourceLocation id = ITEM.readValue(buffer, context, null);
        Item item = id == null ? Items.f_41852_ : (Item)ForgeRegistries.ITEMS.getValue(id);
        int count = buffer.readIntSegmented(7);
        CompoundTag tag = TAG.readValue(buffer, context, null);
        CompoundTag caps = TAG.readValue(buffer, context, null);
        ItemStack stack = new ItemStack((ItemLike)item, count, caps);
        stack.m_41751_(tag);
        return stack;
    }
}

