/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.spi;

import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class RecipeInventory
implements Container {
    protected final NonNullList<ItemStack> slots;

    public RecipeInventory(int inputCount) {
        this.slots = NonNullList.m_122780_((int)(inputCount + 1), (Object)ItemStack.f_41583_);
    }

    public int getInputSlotCount() {
        return this.slots.size() - 1;
    }

    public int m_6643_() {
        return this.slots.size();
    }

    public boolean m_7983_() {
        return this.slots.isEmpty();
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.slots.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemStack = (ItemStack)this.slots.get(index);
        if (index == this.outputSlotIndex() && !itemStack.m_41619_()) {
            ItemStack andSplit = ContainerHelper.m_18969_(this.slots, (int)index, (int)itemStack.m_41613_());
            this.consumeIngredients();
            this.updateResult();
            return andSplit;
        }
        ItemStack splitStack = ContainerHelper.m_18969_(this.slots, (int)index, (int)count);
        this.updateResult();
        return splitStack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack andRemove = ContainerHelper.m_18966_(this.slots, (int)index);
        this.updateResult();
        return andRemove;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.slots.set(index, (Object)stack);
        this.updateResult();
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player playerEntity) {
        return true;
    }

    public void m_6211_() {
        this.slots.clear();
    }

    public void updateResult() {
        ItemStack outputItemStack = this.m_8020_(this.outputSlotIndex());
        if (this.recipeFulfilled()) {
            this.slots.set(this.outputSlotIndex(), (Object)this.resultingItemStack());
        } else if (!outputItemStack.m_41619_()) {
            this.slots.set(this.outputSlotIndex(), (Object)ItemStack.f_41583_);
        }
    }

    public void consumeIngredients() {
        this.forEachInput(inputIndex -> this.m_7407_((int)inputIndex, 1));
    }

    public abstract boolean recipeFulfilled();

    public abstract ItemStack resultingItemStack();

    public boolean isIngredientSlotsFilled() {
        for (int i = 0; i < this.slots.size() - 1; ++i) {
            ItemStack ingredientStack = this.m_8020_(i);
            if (!ingredientStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void forEachInput(Consumer<Integer> inputConsumer) {
        for (int i = 0; i < this.slots.size() - 1; ++i) {
            inputConsumer.accept(i);
        }
    }

    public int outputSlotIndex() {
        return this.slots.size() - 1;
    }

    public boolean isIngredientIndex(int index) {
        return index < this.outputSlotIndex();
    }
}

