/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.inventory;

import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.slot.ConditionalReadSlot;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.ItemShardPouch;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ShardPouchContainer
extends OverSizedSlotContainer {
    private final int pouchSlot;
    private final Inventory inventory;

    public ShardPouchContainer(int id, Inventory playerInventory, int pouchSlot) {
        super(ModContainers.SHARD_POUCH_CONTAINER, id, playerInventory.f_35978_);
        this.inventory = playerInventory;
        this.pouchSlot = pouchSlot;
        if (this.hasPouch()) {
            playerInventory.f_35978_.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(playerInvHandler -> {
                ItemStack pouch = this.inventory.m_8020_(this.pouchSlot);
                pouch.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(pouchHandler -> this.initSlots((IItemHandler)playerInvHandler, (IItemHandler)pouchHandler));
            });
        }
    }

    private void initSlots(IItemHandler playerInvHandler, final IItemHandler pouchHandler) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_((Slot)new ConditionalReadSlot(playerInvHandler, column + row * 9 + 9, 8 + column * 18, 55 + row * 18, this::canAccess));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_((Slot)new ConditionalReadSlot(playerInvHandler, hotbarSlot, 8 + hotbarSlot * 18, 113, this::canAccess));
        }
        this.m_38897_((Slot)new ConditionalReadSlot(pouchHandler, 0, 80, 16, (slot, stack) -> this.canAccess((int)slot, (ItemStack)stack) && stack.m_41720_() == ModItems.SOUL_SHARD){

            public int m_5866_(@Nonnull ItemStack stack) {
                return pouchHandler.getSlotLimit(0);
            }

            public void m_6654_() {
                ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(this.getSlotIndex(), this.m_7993_());
            }
        });
    }

    public boolean m_6875_(Player player) {
        return this.hasPouch();
    }

    public boolean canAccess(int slot, ItemStack slotStack) {
        return this.hasPouch() && !(slotStack.m_41720_() instanceof ItemShardPouch);
    }

    public boolean hasPouch() {
        ItemStack pouchStack = this.inventory.m_8020_(this.pouchSlot);
        return !pouchStack.m_41619_() && pouchStack.m_41720_() instanceof ItemShardPouch;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.m_38903_(slotStack, 36, 37, false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : (index >= 27 && index < 36 ? !this.m_38903_(slotStack, 0, 27, false) : !this.m_38903_(slotStack, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return itemstack;
    }
}

