/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.inventory;

import com.mojang.datafixers.util.Pair;
import iskallia.vault.block.entity.MagnetTableTile;
import iskallia.vault.config.MagnetConfigs;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSlotIcons;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.MagnetItem;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MagnetTableContainerMenu
extends AbstractContainerMenu {
    private static final Pair<ResourceLocation, ResourceLocation>[] EMPTY_SLOT_TEXTURES = new Pair[]{Pair.of((Object)InventoryMenu.f_39692_, (Object)ModSlotIcons.MAGNET_TABLE_SLOT_0_NO_ITEM), Pair.of((Object)InventoryMenu.f_39692_, (Object)ModSlotIcons.MAGNET_TABLE_SLOT_1_NO_ITEM), Pair.of((Object)InventoryMenu.f_39692_, (Object)ModSlotIcons.MAGNET_TABLE_SLOT_2_NO_ITEM), Pair.of((Object)InventoryMenu.f_39692_, (Object)ModSlotIcons.MAGNET_TABLE_SLOT_3_NO_ITEM)};
    public final Map<MagnetItem.Stat, MagnetConfigs.Upgrade> upgrades = ModConfigs.MAGNET_CONFIG.getAllUpgrades();
    public final Container container;

    public MagnetTableContainerMenu(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (Container)null);
    }

    public MagnetTableContainerMenu(int id, Inventory playerInventory, @Nullable Container container) {
        super(ModContainers.MAGNET_TABLE_CONTAINER, id);
        int si;
        this.container = Objects.requireNonNullElseGet(container, () -> new SimpleContainer(5){

            public void m_6596_() {
                super.m_6596_();
                MagnetTableContainerMenu.this.m_6199_((Container)this);
            }
        });
        MagnetTableContainerMenu.m_38869_((Container)this.container, (int)5);
        this.container.m_5856_(playerInventory.f_35978_);
        this.m_38897_(new Slot(this.container, 0, 55, 24){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_((Item)ModItems.MAGNET_ITEM);
            }
        });
        this.m_38897_(new MaterialSlot(this.container, 1, 43, 64, itemStack -> itemStack.m_150930_(ModConfigs.MAGNET_CONFIG.getMaterialItem(0)), EMPTY_SLOT_TEXTURES[0]));
        this.m_38897_(new MaterialSlot(this.container, 2, 66, 64, itemStack -> itemStack.m_150930_(ModConfigs.MAGNET_CONFIG.getMaterialItem(1)), EMPTY_SLOT_TEXTURES[1]));
        this.m_38897_(new MaterialSlot(this.container, 3, 43, 86, itemStack -> itemStack.m_150930_(ModConfigs.MAGNET_CONFIG.getMaterialItem(2)), EMPTY_SLOT_TEXTURES[2]));
        this.m_38897_(new MaterialSlot(this.container, 4, 66, 86, itemStack -> itemStack.m_150930_(ModConfigs.MAGNET_CONFIG.getMaterialItem(3)), EMPTY_SLOT_TEXTURES[3]));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.m_38897_(new Slot((Container)playerInventory, sj + (si + 1) * 9, 8 + sj * 18, 118 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.m_38897_(new Slot((Container)playerInventory, si, 8 + si * 18, 176));
        }
    }

    public void m_6199_(Container pInventory) {
        super.m_6199_(pInventory);
    }

    public boolean m_6875_(Player playerIn) {
        return this.container.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack otherStack = slot.m_7993_();
            itemstack = otherStack.m_41777_();
            if (index < this.container.m_6643_() ? !this.m_38903_(otherStack, this.container.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(otherStack, 0, this.container.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (otherStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.container.m_5785_(playerIn);
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        if (pId < MagnetItem.Stat.values().length) {
            MagnetItem.Stat stat = MagnetItem.Stat.values()[pId];
            MagnetConfigs.Upgrade upgrade = this.upgrades.get((Object)stat);
            for (int i = 1; i < 5; ++i) {
                ((Slot)this.f_38839_.get(i)).m_7993_().m_41774_(upgrade.getMaterialCost(i - 1));
            }
            ItemStack magnet = ((Slot)this.f_38839_.get(0)).m_7993_();
            MagnetItem.increaseStatUpgrade(magnet, stat, upgrade.getYield(pPlayer.m_21187_()));
            int decrement = ModConfigs.MAGNET_CONFIG.getSturdinessDecrement();
            int s = MagnetItem.getSturdiness(magnet);
            MagnetItem.decreaseSturdiness(magnet, decrement);
            Container container = this.container;
            if (container instanceof MagnetTableTile) {
                MagnetTableTile tile = (MagnetTableTile)container;
                boolean playSound = true;
                float cutoff = ModConfigs.MAGNET_CONFIG.getSturdinessCutoff();
                if ((float)s < tile.m_58904_().f_46441_.nextFloat() * 100.0f) {
                    tile.m_58904_().m_5594_(null, tile.m_58899_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.1f);
                    ((Slot)this.f_38839_.get(0)).m_5852_(ItemStack.f_41583_);
                    playSound = false;
                } else if ((float)MagnetItem.getSturdiness(magnet) <= cutoff && MagnetItem.getPerk(magnet) == MagnetItem.Perk.NONE) {
                    MagnetItem.addRandomPerk(magnet, tile.m_58904_().f_46441_);
                }
                if (playSound) {
                    tile.m_58904_().m_5594_(null, tile.m_58899_(), ModSounds.MAGNET_TABLE, SoundSource.BLOCKS, 1.0f, 1.1f);
                }
            }
            this.m_38946_();
            return true;
        }
        return super.m_6366_(pPlayer, pId);
    }

    private static class MaterialSlot
    extends Slot {
        private final Predicate<ItemStack> itemFilter;
        private final Pair<ResourceLocation, ResourceLocation> emptyIconLocation;

        public MaterialSlot(Container pContainer, int pIndex, int pX, int pY, Predicate<ItemStack> itemFilter, Pair<ResourceLocation, ResourceLocation> emptyIconLocation) {
            super(pContainer, pIndex, pX, pY);
            this.itemFilter = itemFilter;
            this.emptyIconLocation = emptyIconLocation;
        }

        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return this.emptyIconLocation;
        }

        public boolean m_5857_(@Nonnull ItemStack pStack) {
            return this.itemFilter.test(pStack);
        }
    }
}

