/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.inventory;

import iskallia.vault.block.entity.EtchingVendorControllerTileEntity;
import iskallia.vault.container.slot.EtchingBuySlot;
import iskallia.vault.container.slot.FilteredSlot;
import iskallia.vault.entity.entity.EtchingVendorEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModContainers;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EtchingTradeContainer
extends AbstractContainerMenu {
    private final Container tradeInventory = new SimpleContainer(6);
    private final Level world;
    private final int vendorEntityId;

    public EtchingTradeContainer(int containerId, Inventory playerInventory, int vendorEntityId) {
        super(ModContainers.ETCHING_TRADE_CONTAINER, containerId);
        this.world = playerInventory.f_35978_.f_19853_;
        this.vendorEntityId = vendorEntityId;
        this.initPlayerSlots(playerInventory);
        this.initTradeSlots();
    }

    private void initPlayerSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 102 + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)playerInventory, hotbarSlot, 8 + hotbarSlot * 18, 160));
        }
    }

    private void initTradeSlots() {
        for (int i = 0; i < 3; ++i) {
            this.m_38897_((Slot)new FilteredSlot((IItemHandler)new InvWrapper(this.tradeInventory), i * 2, 53, 10 + i * 28, stack -> stack.m_41720_() == ModBlocks.VAULT_PLATINUM));
            this.m_38897_((Slot)new EtchingBuySlot(this, (IItemHandler)new InvWrapper(this.tradeInventory), i, i * 2 + 1, 107, 10 + i * 28));
        }
        EtchingVendorEntity vendor = this.getVendor();
        if (vendor == null) {
            return;
        }
        EtchingVendorControllerTileEntity controllerTile = vendor.getControllerTile();
        if (controllerTile == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            EtchingVendorControllerTileEntity.EtchingTrade trade = controllerTile.getTrade(i);
            if (trade == null || trade.isSold()) continue;
            Slot outSlot = this.m_38853_(37 + i * 2);
            outSlot.m_5852_(trade.getSoldEtching().m_41777_());
        }
    }

    @Nullable
    public EtchingVendorEntity getVendor() {
        return (EtchingVendorEntity)this.world.m_6815_(this.vendorEntityId);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.tradeInventory.m_6836_(1, ItemStack.f_41583_);
        this.tradeInventory.m_6836_(3, ItemStack.f_41583_);
        this.tradeInventory.m_6836_(5, ItemStack.f_41583_);
        this.m_150411_(player, this.tradeInventory);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.m_38903_(slotStack, 36, 42, false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : (index >= 27 && index < 36 ? !this.m_38903_(slotStack, 0, 27, false) : !this.m_38903_(slotStack, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        EtchingVendorEntity vendor = this.getVendor();
        return vendor != null && vendor.isValid();
    }
}

