/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.inventory;

import iskallia.vault.block.CryoChamberBlock;
import iskallia.vault.block.entity.CryoChamberTileEntity;
import iskallia.vault.container.slot.ArmorSlot;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModContainers;
import iskallia.vault.world.data.EternalsData;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CryochamberContainer
extends AbstractContainerMenu {
    private final BlockPos tilePos;

    public CryochamberContainer(int windowId, Level world, BlockPos pos, Inventory playerInventory) {
        super(ModContainers.CRYOCHAMBER_CONTAINER, windowId);
        Object equipmentInventory;
        this.tilePos = pos;
        CryoChamberTileEntity cryoChamber = this.getCryoChamber(world);
        if (world instanceof ServerLevel && cryoChamber != null) {
            equipmentInventory = EternalsData.get((ServerLevel)world).getEternalEquipmentInventory(cryoChamber.getEternalId(), cryoChamber::sendUpdates);
            if (equipmentInventory == null) {
                return;
            }
        } else {
            equipmentInventory = new SimpleContainer(5);
        }
        this.initSlots((Container)equipmentInventory, playerInventory);
    }

    private void initSlots(Container equipmentInventory, Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 129 + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)playerInventory, hotbarSlot, 8 + hotbarSlot * 18, 187));
        }
        this.m_38897_(new ArmorSlot(equipmentInventory, EquipmentSlot.MAINHAND, 0, 151, 26));
        int offsetY = 98;
        int index = 1;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() == EquipmentSlot.Type.HAND) continue;
            this.m_38897_(new ArmorSlot(equipmentInventory, slot, index, 151, offsetY));
            offsetY -= 18;
            ++index;
        }
    }

    public boolean m_6875_(Player player) {
        if (this.getCryoChamber(player.m_20193_()) == null) {
            return false;
        }
        return player.m_20238_(Vec3.m_82512_((Vec3i)this.tilePos)) <= 64.0;
    }

    @Nullable
    public CryoChamberTileEntity getCryoChamber(Level world) {
        BlockState state = world.m_8055_(this.tilePos);
        if (!state.m_60713_((Block)ModBlocks.CRYO_CHAMBER)) {
            return null;
        }
        return CryoChamberBlock.getCryoChamberTileEntity(world, this.tilePos, state);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.m_38903_(slotStack, 36, 41, false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : (index >= 27 && index < 36 ? !this.m_38903_(slotStack, 0, 27, false) : !this.m_38903_(slotStack, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return itemstack;
    }

    public BlockPos getTilePos() {
        return this.tilePos;
    }
}

