/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.inventory;

import iskallia.vault.block.entity.CatalystInfusionTableTileEntity;
import iskallia.vault.container.slot.FilteredSlot;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModContainers;
import iskallia.vault.item.VaultCatalystItem;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class CatalystInfusionTableContainer
extends AbstractContainerMenu {
    private final CatalystInfusionTableTileEntity blockEntity;
    private final BlockPos tilePos;

    public CatalystInfusionTableContainer(int windowId, Level world, BlockPos pos, Inventory playerInventory) {
        super(ModContainers.CATALYST_INFUSION_TABLE_CONTAINER, windowId);
        this.tilePos = pos;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CatalystInfusionTableTileEntity) {
            CatalystInfusionTableTileEntity tileEntity = (CatalystInfusionTableTileEntity)blockEntity;
            this.initSlots((IItemHandler)tileEntity.getCatalystStackHandler(), (IItemHandler)tileEntity.getInfuserStackHandler(), (IItemHandler)tileEntity.getOutputStackHandler(), playerInventory);
            this.blockEntity = tileEntity;
        } else {
            this.blockEntity = null;
        }
    }

    private void initSlots(IItemHandler catalystStackHandler, IItemHandler infuserItemHandler, IItemHandler outputItemHandler, Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 84 + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)playerInventory, hotbarSlot, 8 + hotbarSlot * 18, 142));
        }
        Predicate<ItemStack> catalystFilter = stack -> stack.m_41720_() instanceof VaultCatalystItem;
        this.m_38897_((Slot)new FilteredSlot(catalystStackHandler, 0, 56, 35, catalystFilter));
        Predicate<ItemStack> infuserFilter = stack -> ItemStack.m_150942_((ItemStack)stack, (ItemStack)ModConfigs.CATALYST_INFUSION_TABLE.getInfusionItem());
        this.m_38897_((Slot)new FilteredSlot(infuserItemHandler, 0, 34, 35, infuserFilter));
        this.m_38897_((Slot)new OutputSlot(outputItemHandler, 0, 116, 35));
    }

    public boolean isActive() {
        return this.blockEntity != null && this.blockEntity.isActive();
    }

    public float getProgress() {
        return this.blockEntity == null ? 0.0f : this.blockEntity.getProgress();
    }

    public boolean m_6875_(Player player) {
        Level world = player.m_20193_();
        if (!(world.m_7702_(this.tilePos) instanceof CatalystInfusionTableTileEntity)) {
            return false;
        }
        return player.m_20275_((double)this.tilePos.m_123341_() + 0.5, (double)this.tilePos.m_123342_() + 0.5, (double)this.tilePos.m_123343_() + 0.5) <= 64.0;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.m_38903_(slotStack, 36, 38, false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : (index >= 27 && index < 36 ? !this.m_38903_(slotStack, 0, 27, false) : !this.m_38903_(slotStack, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemstack;
    }

    private static class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }
    }
}

