/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.world.data.VaultCharmData;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class VaultCharmControllerContainer
extends AbstractContainerMenu {
    public Container visibleItems;
    private final int inventorySize;
    private final List<ResourceLocation> whitelist;
    private final int invStartIndex;
    private final int invEndIndex;
    private int currentStart = 0;
    private int currentEnd = 53;
    private float scrollDelta = 0.0f;

    public VaultCharmControllerContainer(int windowId, Inventory playerInventory, CompoundTag data) {
        super(ModContainers.VAULT_CHARM_CONTROLLER_CONTAINER, windowId);
        VaultCharmData.VaultCharmInventory vaultCharmInventory = VaultCharmData.VaultCharmInventory.fromNbt(data);
        this.inventorySize = vaultCharmInventory.getSize();
        this.whitelist = vaultCharmInventory.getWhitelist();
        this.initVisibleItems();
        this.initPlayerInventorySlots(playerInventory);
        this.initCharmControllerSlots();
        this.invStartIndex = 36;
        this.invEndIndex = 36 + Math.min(54, this.inventorySize);
    }

    private void initVisibleItems() {
        this.visibleItems = new SimpleContainer(this.inventorySize);
        int index = 0;
        for (ResourceLocation id : this.whitelist) {
            this.visibleItems.m_6836_(index, new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(id)));
            ++index;
        }
    }

    private void initPlayerInventorySlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, column + row * 9 + 9, 9 + column * 18, 140 + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)playerInventory, hotbarSlot, 9 + hotbarSlot * 18, 198));
        }
    }

    private void initCharmControllerSlots() {
        int rows = Math.min(6, this.inventorySize / 9);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new VaultCharmControllerSlot(this.visibleItems, column + row * 9, 9 + column * 18, 18 + row * 18));
            }
        }
    }

    public boolean canScroll() {
        return this.inventorySize > 54;
    }

    public void scrollTo(float scroll) {
        if (scroll >= 1.0f && this.scrollDelta >= 1.0f) {
            return;
        }
        this.shiftInventoryIndexes(this.scrollDelta - scroll < 0.0f);
        this.updateVisibleItems();
        this.scrollDelta = scroll;
    }

    private void shiftInventoryIndexes(boolean ascending) {
        if (ascending) {
            this.currentStart = Math.min(this.inventorySize - 54, this.currentStart + 9);
            this.currentEnd = Math.min(this.currentStart + 54, this.inventorySize);
        } else {
            this.currentStart = Math.max(0, this.currentStart - 9);
            this.currentEnd = Math.max(54, this.currentEnd - 9);
        }
    }

    private void updateVisibleItems() {
        for (int i = 0; i < this.getInventorySize() && i < 54; ++i) {
            int whitelistIndex = this.currentStart + i;
            if (whitelistIndex >= this.whitelist.size()) {
                this.visibleItems.m_6836_(i, ItemStack.f_41583_);
                this.f_38841_.set(i, (Object)ItemStack.f_41583_);
                continue;
            }
            ResourceLocation id = this.whitelist.get(whitelistIndex);
            ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(id));
            this.visibleItems.m_6836_(i, stack);
            this.f_38841_.add(i, (Object)stack);
        }
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (!slot.m_6657_()) {
            return stack;
        }
        ItemStack slotStack = slot.m_7993_();
        stack = slotStack.m_41777_();
        if (slot instanceof VaultCharmControllerSlot) {
            this.whitelist.remove(slot.m_7993_().m_41720_().getRegistryName());
            slot.m_5852_(ItemStack.f_41583_);
            this.updateVisibleItems();
            return ItemStack.f_41583_;
        }
        if (this.whitelist.size() < this.inventorySize && !this.whitelist.contains(stack.m_41720_().getRegistryName())) {
            this.whitelist.add(stack.m_41720_().getRegistryName());
            float pitch = MathUtilities.randomFloat(0.9f, 1.1f);
            playerIn.f_19853_.m_5594_(null, playerIn.m_142538_(), SoundEvents.f_12130_, SoundSource.PLAYERS, 0.7f, pitch);
            this.updateVisibleItems();
            return ItemStack.f_41583_;
        }
        if (index >= 0 && index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : (index >= 27 && index < 36 ? !this.m_38903_(slotStack, 0, 27, false) : !this.m_38903_(slotStack, 0, 36, false))) {
            return ItemStack.f_41583_;
        }
        if (slotStack.m_41613_() == 0) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (slotStack.m_41613_() == stack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(playerIn, slotStack);
        this.updateVisibleItems();
        return stack;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        Slot slot;
        Slot slot2 = slot = slotId >= 0 ? this.m_38853_(slotId) : null;
        if (slot instanceof VaultCharmControllerSlot) {
            ItemStack stack;
            if (slot.m_6657_()) {
                this.whitelist.remove(slot.m_7993_().m_41720_().getRegistryName());
                slot.m_5852_(ItemStack.f_41583_);
                this.updateVisibleItems();
                return;
            }
            if (!this.m_142621_().m_41619_() && !this.whitelist.contains((stack = this.m_142621_().m_41777_()).m_41720_().getRegistryName())) {
                this.whitelist.add(stack.m_41720_().getRegistryName());
                this.updateVisibleItems();
                return;
            }
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        if (slot.f_40219_ >= this.invStartIndex) {
            return false;
        }
        return super.m_5882_(stack, slot);
    }

    public void m_6877_(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            VaultCharmData.get(sPlayer.m_183503_()).updateWhitelist(sPlayer, this.whitelist);
        }
        super.m_6877_(player);
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    public List<ResourceLocation> getWhitelist() {
        return this.whitelist;
    }

    public int getCurrentAmountWhitelisted() {
        return this.whitelist.size();
    }

    public class VaultCharmControllerSlot
    extends Slot {
        public VaultCharmControllerSlot(Container inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            if (this.m_6657_()) {
                return false;
            }
            if (stack.m_41720_() == ModItems.VAULT_CHARM) {
                return false;
            }
            ResourceLocation id = stack.m_41720_().getRegistryName();
            return !VaultCharmControllerContainer.this.whitelist.contains(id);
        }

        public int m_6641_() {
            return 1;
        }
    }
}

