/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.block.entity.VaultArtisanStationTileEntity;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.oversized.OverSizedTabSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.gear.modification.GearModificationAction;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModGearModifications;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSlotIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class VaultArtisanStationContainer
extends OverSizedSlotContainer {
    private final List<GearModificationAction> modificationActions = new ArrayList<GearModificationAction>();
    private final VaultArtisanStationTileEntity tileEntity;
    private final BlockPos tilePos;

    public VaultArtisanStationContainer(int windowId, Level world, BlockPos pos, Inventory playerInventory) {
        super(ModContainers.VAULT_ARTISAN_STATION_CONTAINER, windowId, playerInventory.f_35978_);
        this.tilePos = pos;
        BlockEntity tile = world.m_7702_(this.tilePos);
        if (tile instanceof VaultArtisanStationTileEntity) {
            VaultArtisanStationTileEntity craftingStationTileEntity;
            this.tileEntity = craftingStationTileEntity = (VaultArtisanStationTileEntity)tile;
            this.initSlots(playerInventory);
        } else {
            this.tileEntity = null;
        }
    }

    public List<GearModificationAction> getModificationActions() {
        return Collections.unmodifiableList(this.modificationActions);
    }

    public Slot getPlatingSlot() {
        return (Slot)this.f_38839_.get(36);
    }

    public Slot getBronzeSlot() {
        return (Slot)this.f_38839_.get(37);
    }

    public Slot getGearInputSlot() {
        return (Slot)this.f_38839_.get(this.f_38839_.size() - 1);
    }

    private void initSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new TabSlot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 124 + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new TabSlot((Container)playerInventory, hotbarSlot, 8 + hotbarSlot * 18, 182));
        }
        OverSizedInventory invContainer = this.tileEntity.getInventory();
        this.m_38897_(new OverSizedTabSlot(invContainer, 0, 69, 20).setFilter(stack -> stack.m_150930_((Item)ModItems.VAULT_PLATING)).setBackground(InventoryMenu.f_39692_, ModSlotIcons.PLATING_NO_ITEM));
        this.m_38897_(new OverSizedTabSlot(invContainer, 1, 89, 20).setFilter(stack -> stack.m_150930_((Item)ModBlocks.VAULT_BRONZE)).setBackground(InventoryMenu.f_39692_, ModSlotIcons.COINS_NO_ITEM));
        this.addModSlot(new OverSizedTabSlot(invContainer, 2, 8, 20), ModGearModifications.REFORGE_ALL_MODIFIERS, true);
        this.addModSlot(new OverSizedTabSlot(invContainer, 3, 8, 44), ModGearModifications.ADD_MODIFIER, true);
        this.addModSlot(new OverSizedTabSlot(invContainer, 4, 8, 68), ModGearModifications.REMOVE_MODIFIER, true);
        this.addModSlot(new OverSizedTabSlot(invContainer, 5, 8, 92), ModGearModifications.REFORGE_ALL_ADD_TAG, true);
        this.addModSlot(new OverSizedTabSlot(invContainer, 6, 150, 20), ModGearModifications.RESET_POTENTIAL, false);
        this.addModSlot(new OverSizedTabSlot(invContainer, 7, 150, 44), ModGearModifications.REFORGE_REPAIR_SLOTS, false);
        this.addModSlot(new OverSizedTabSlot(invContainer, 8, 150, 68), ModGearModifications.REFORGE_ALL_IMPLICITS, false);
        this.addModSlot(new OverSizedTabSlot(invContainer, 9, 150, 92), ModGearModifications.REFORGE_RANDOM_TIER, false);
        SimpleContainer inputContainer = this.tileEntity.getGearInput();
        this.m_38897_(new TabSlot((Container)inputContainer, 0, 79, 60){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof VaultGearItem;
            }
        });
    }

    private void addModSlot(OverSizedTabSlot slot, GearModification modification, boolean rightSide) {
        this.m_38897_(slot);
        slot.setFilter(modification.getStackFilter());
        this.modificationActions.add(new GearModificationAction(slot.f_40219_, modification, rightSide));
    }

    public GearModificationAction getModificationAction(GearModification modification) {
        for (GearModificationAction action : this.modificationActions) {
            if (!((Object)((Object)action.modification())).equals((Object)modification)) continue;
            return action;
        }
        return null;
    }

    @Nullable
    public GearModificationAction getModificationAction(int slot) {
        for (GearModificationAction action : this.modificationActions) {
            if (action.slotIndex() != slot) continue;
            return action;
        }
        return null;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.moveOverSizedItemStackTo(slotStack, slot, 36, this.f_38839_.size(), false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.moveOverSizedItemStackTo(slotStack, slot, 27, 36, false) : (index >= 27 && index < 36 ? !this.moveOverSizedItemStackTo(slotStack, slot, 0, 27, false) : !this.moveOverSizedItemStackTo(slotStack, slot, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemstack;
    }

    public BlockPos getTilePos() {
        return this.tilePos;
    }

    public VaultArtisanStationTileEntity getTileEntity() {
        return this.tileEntity;
    }

    public boolean m_6875_(Player player) {
        if (this.tileEntity == null) {
            return false;
        }
        return this.tileEntity.getInventory().m_6542_(this.player);
    }
}

