/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.container.inventory.TransmogTableInventory;
import iskallia.vault.container.slot.RecipeOutputSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.container.slot.VaultCoinSlot;
import iskallia.vault.container.slot.VaultGearSlot;
import iskallia.vault.container.spi.AbstractElementContainer;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.util.EntityHelper;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TransmogTableContainer
extends AbstractElementContainer {
    protected TransmogTableInventory internalInventory = new TransmogTableInventory();
    protected AbstractElementContainer.SlotIndexRange playerInventoryIndexRange;
    protected AbstractElementContainer.SlotIndexRange hotbarIndexRange;
    protected AbstractElementContainer.SlotIndexRange internalInventoryIndexRange;
    protected ResourceLocation selectedModelId;

    public TransmogTableContainer(int id, Player player) {
        super(ModContainers.TRANSMOG_TABLE_CONTAINER, id, player);
        int offsetX = 0;
        int offsetY = 0;
        int containerSlotIndex = 0;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = column + (row + 1) * 9;
                int x = 8 + column * 18 + offsetX;
                int y = 84 + row * 18 + offsetY;
                this.m_38897_(new TabSlot((Container)player.m_150109_(), index, x, y));
                ++containerSlotIndex;
            }
        }
        this.playerInventoryIndexRange = new AbstractElementContainer.SlotIndexRange(0, containerSlotIndex);
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            int x = 8 + hotbarSlot * 18 + offsetX;
            int y = 142 + offsetY;
            this.m_38897_(new TabSlot((Container)player.m_150109_(), hotbarSlot, x, y));
            ++containerSlotIndex;
        }
        this.hotbarIndexRange = new AbstractElementContainer.SlotIndexRange(this.playerInventoryIndexRange.end(), containerSlotIndex);
        this.m_38897_(new VaultGearSlot(this.internalInventory, 0, 63, 61));
        ++containerSlotIndex;
        this.m_38897_(new VaultCoinSlot(this.internalInventory, 1, 92, 61, (Item)ModBlocks.VAULT_BRONZE));
        ++containerSlotIndex;
        this.m_38897_(new RecipeOutputSlot(this.internalInventory, this.internalInventory.outputSlotIndex(), 152, 61));
        this.internalInventoryIndexRange = new AbstractElementContainer.SlotIndexRange(this.hotbarIndexRange.end(), ++containerSlotIndex);
    }

    public TransmogTableInventory getInternalInventory() {
        return this.internalInventory;
    }

    public AbstractElementContainer.SlotIndexRange getInternalInventoryIndexRange() {
        return this.internalInventoryIndexRange;
    }

    public ResourceLocation getSelectedModelId() {
        return this.selectedModelId;
    }

    public void selectModelId(ResourceLocation modelId) {
        this.selectedModelId = modelId;
    }

    public ItemStack getPreviewItemStack() {
        ResourceLocation selectedModelId = this.getSelectedModelId();
        if (selectedModelId == null) {
            return ItemStack.f_41583_;
        }
        int gearSlotIndex = this.internalInventoryIndexRange.getContainerIndex(0);
        ItemStack gearStack = this.m_38853_(gearSlotIndex).m_7993_();
        if (gearStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack displayStack = new ItemStack((ItemLike)gearStack.m_41720_());
        VaultGearData gearData = VaultGearData.read(displayStack);
        gearData.setState(VaultGearState.IDENTIFIED);
        gearData.updateAttribute(ModGearAttributes.GEAR_MODEL, selectedModelId);
        gearData.write(displayStack);
        return displayStack;
    }

    public boolean priceFulfilled() {
        Slot bronzeSlot = this.m_38853_(this.internalInventoryIndexRange.getContainerIndex(1));
        return bronzeSlot.m_6657_() && bronzeSlot.m_7993_().m_150930_((Item)ModBlocks.VAULT_BRONZE) && bronzeSlot.m_7993_().m_41613_() >= this.copperCost();
    }

    public int copperCost() {
        Slot gearSlot = this.m_38853_(this.internalInventoryIndexRange.getContainerIndex(0));
        ItemStack gearItem = gearSlot.m_7993_();
        if (gearItem.m_41619_()) {
            return -1;
        }
        VaultGearData gearData = VaultGearData.read(gearItem);
        return Mth.m_14045_((int)gearData.getItemLevel(), (int)1, (int)64);
    }

    public boolean m_6875_(@Nonnull Player player) {
        return this.internalInventory.m_6542_(player);
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.internalInventory.forEachInput(relativeIndex -> {
            ItemStack itemStack = this.internalInventory.m_8020_((int)relativeIndex);
            if (!itemStack.m_41619_()) {
                EntityHelper.giveItem(player, itemStack);
            }
        });
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack slotItem = slot.m_7993_();
        ItemStack copiedStack = slotItem.m_41777_();
        if (this.playerInventoryIndexRange.contains(index) || this.hotbarIndexRange.contains(index)) {
            if (this.moveItemStackTo(slotItem, this.internalInventoryIndexRange, false)) {
                return copiedStack;
            }
            return ItemStack.f_41583_;
        }
        if (this.internalInventoryIndexRange.contains(index)) {
            if (this.m_38903_(slotItem, this.playerInventoryIndexRange.start(), this.hotbarIndexRange.end(), false)) {
                return copiedStack;
            }
            return ItemStack.f_41583_;
        }
        return copiedStack;
    }
}

