/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.container.NBTElementContainer;
import iskallia.vault.container.slot.ArmorTabSlot;
import iskallia.vault.container.slot.CurioTabSlot;
import iskallia.vault.container.slot.OffhandTabSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.container.spi.AbstractElementContainer;
import iskallia.vault.core.vault.stat.StatTotals;
import iskallia.vault.init.ModContainers;
import iskallia.vault.mixin.AccessorAbstractContainerMenu;
import iskallia.vault.network.message.ClientboundCuriosScrollMessage;
import iskallia.vault.network.message.ServerboundCuriosScrollMessage;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class StatisticsTabContainer
extends NBTElementContainer<StatTotals> {
    private static final EquipmentSlot[] EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final CurioContainerHandler curioContainerHandler;
    private final AbstractElementContainer.SlotIndexRange hotbarSlotIndexRange;
    private final AbstractElementContainer.SlotIndexRange inventorySlotIndexRange;
    private final AbstractElementContainer.SlotIndexRange hotbarInventorySlotIndexRange;
    private final AbstractElementContainer.SlotIndexRange armorSlotIndexRange;
    private final AbstractElementContainer.SlotIndexRange offhandSlotIndexRange;
    private final AbstractElementContainer.SlotIndexRange curioSlotIndexRange;

    public StatisticsTabContainer(int id, Inventory playerInventory, StatTotals statTotals) {
        super(() -> ModContainers.STATISTICS_TAB_CONTAINER, id, playerInventory.f_35978_, statTotals);
        int offsetX = 0;
        int offsetY = 18;
        int nextSlotIndex = 0;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new TabSlot((Container)playerInventory, column + (row + 1) * 9, 8 + column * 18 + offsetX, 84 + row * 18 + offsetY));
                ++nextSlotIndex;
            }
        }
        this.inventorySlotIndexRange = new AbstractElementContainer.SlotIndexRange(0, nextSlotIndex);
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new TabSlot((Container)playerInventory, hotbarSlot, 8 + hotbarSlot * 18 + offsetX, 142 + offsetY));
            ++nextSlotIndex;
        }
        this.hotbarSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.inventorySlotIndexRange.end(), nextSlotIndex);
        this.hotbarInventorySlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.inventorySlotIndexRange.start(), this.hotbarSlotIndexRange.end());
        for (int armorSlot = 0; armorSlot < 4; ++armorSlot) {
            this.m_38897_(new ArmorTabSlot((Container)playerInventory, 39 - armorSlot, 8 + offsetX, 8 + armorSlot * 18 + offsetY - 18, EQUIPMENT_SLOTS[armorSlot], this.player));
            ++nextSlotIndex;
        }
        this.armorSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.hotbarSlotIndexRange.end(), nextSlotIndex);
        this.m_38897_(new OffhandTabSlot((Container)playerInventory, 40, 8 + offsetX, 62 + offsetY));
        this.offhandSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.armorSlotIndexRange.end(), ++nextSlotIndex);
        this.curioContainerHandler = new CurioContainerHandler(TabContainerAccessDecorator.of(this), nextSlotIndex, -20, 8, 8);
        this.curioContainerHandler.scrollToIndex(0);
        this.curioSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.offhandSlotIndexRange.end(), this.offhandSlotIndexRange.end() + this.curioContainerHandler.maxSlotsDisplayed);
    }

    @Override
    public boolean m_6875_(@Nonnull Player player) {
        return true;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            int i;
            ItemStack slotItemStack = slot.m_7993_();
            itemStack = slotItemStack.m_41777_();
            EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)slotItemStack);
            if (this.armorSlotIndexRange.contains(index) ? !this.moveItemStackTo(slotItemStack, this.hotbarInventorySlotIndexRange, false) : (equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(this.armorSlotIndexRange.end() - equipmentSlot.m_20749_() - 1)).m_6657_() ? !this.m_38903_(slotItemStack, i = this.armorSlotIndexRange.end() - equipmentSlot.m_20749_() - 1, i + 1, false) : (index < this.curioSlotIndexRange.start() && !CuriosApi.getCuriosHelper().getCurioTags(slotItemStack.m_41720_()).isEmpty() ? !this.moveItemStackTo(slotItemStack, this.curioSlotIndexRange, false) : (equipmentSlot == EquipmentSlot.OFFHAND && !((Slot)this.f_38839_.get(this.offhandSlotIndexRange.start())).m_6657_() ? !this.moveItemStackTo(slotItemStack, this.offhandSlotIndexRange, false) : (this.inventorySlotIndexRange.contains(index) ? !this.moveItemStackTo(slotItemStack, this.hotbarSlotIndexRange, false) : (this.hotbarSlotIndexRange.contains(index) ? !this.moveItemStackTo(slotItemStack, this.inventorySlotIndexRange, false) : !this.moveItemStackTo(slotItemStack, this.hotbarInventorySlotIndexRange, false))))))) {
                return ItemStack.f_41583_;
            }
        }
        return itemStack;
    }

    public CurioContainerHandler getCurioContainerHandler() {
        return this.curioContainerHandler;
    }

    public static class CurioContainerHandler {
        private final IContainerAccess containerAccess;
        private final int slotStartIndex;
        private final int offsetX;
        private final int offsetY;
        private final int maxSlotsDisplayed;
        private int lastScrollIndex;

        private CurioContainerHandler(IContainerAccess containerAccess, int slotStartIndex, int offsetX, int offsetY, int maxSlotsDisplayed) {
            this.containerAccess = containerAccess;
            this.slotStartIndex = slotStartIndex;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.maxSlotsDisplayed = maxSlotsDisplayed;
        }

        public void scrollToIndex(int targetIndex) {
            NonNullList<Slot> slots = this.containerAccess.getSlots();
            slots.subList(this.slotStartIndex, slots.size()).clear();
            NonNullList<ItemStack> lastSlots = this.containerAccess.getLastSlots();
            lastSlots.subList(this.slotStartIndex, lastSlots.size()).clear();
            NonNullList<ItemStack> remoteSlots = this.containerAccess.getRemoteSlots();
            remoteSlots.subList(this.slotStartIndex, remoteSlots.size()).clear();
            this.getCuriosHandler().ifPresent(itemHandler -> {
                Map curioMap = itemHandler.getCurios();
                int startingIndex = this.calculateScrollStartIndex(targetIndex, curioMap);
                this.addSlots(curioMap, startingIndex, this.offsetY);
            });
            if (!this.containerAccess.isClient()) {
                ClientboundCuriosScrollMessage.send((ServerPlayer)this.containerAccess.getPlayer(), this.containerAccess.getContainerId(), targetIndex);
            }
            this.lastScrollIndex = targetIndex;
        }

        private int calculateScrollStartIndex(int targetIndex, Map<String, ICurioStacksHandler> curioMap) {
            int slotCount = 0;
            int index = 0;
            for (Map.Entry<String, ICurioStacksHandler> entry : curioMap.entrySet()) {
                ICurioStacksHandler curioStacksHandler = entry.getValue();
                if (!curioStacksHandler.isVisible()) continue;
                IDynamicStackHandler dynamicStackHandler = curioStacksHandler.getStacks();
                for (int i = 0; i < dynamicStackHandler.getSlots() && slotCount < this.maxSlotsDisplayed; ++i) {
                    if (index >= targetIndex) {
                        ++slotCount;
                    }
                    ++index;
                }
            }
            return Mth.m_14045_((int)(index - this.maxSlotsDisplayed), (int)0, (int)targetIndex);
        }

        private void addSlots(Map<String, ICurioStacksHandler> curioMap, int startingIndex, int offsetY) {
            int index = 0;
            int slotCount = 0;
            for (Map.Entry<String, ICurioStacksHandler> entry : curioMap.entrySet()) {
                ICurioStacksHandler curioStacksHandler = entry.getValue();
                if (!curioStacksHandler.isVisible()) continue;
                IDynamicStackHandler dynamicStackHandler = curioStacksHandler.getStacks();
                for (int slotIndex = 0; slotIndex < dynamicStackHandler.getSlots() && slotCount < this.maxSlotsDisplayed; ++slotIndex) {
                    if (index >= startingIndex) {
                        this.containerAccess.addSlot((Slot)new CurioTabSlot(this.containerAccess.getPlayer(), dynamicStackHandler, slotIndex, entry.getKey(), this.offsetX, offsetY, (NonNullList<Boolean>)curioStacksHandler.getRenders()));
                        ++slotCount;
                        offsetY += 18;
                    }
                    ++index;
                }
            }
        }

        public void scrollTo(float pos) {
            this.getCuriosHandler().ifPresent(itemHandler -> {
                int newScrollIndex = (int)((double)(pos * (float)(itemHandler.getVisibleSlots() - this.maxSlotsDisplayed)) + 0.5);
                if (newScrollIndex < 0) {
                    newScrollIndex = 0;
                }
                if (newScrollIndex == this.lastScrollIndex) {
                    return;
                }
                if (this.containerAccess.isClient()) {
                    ServerboundCuriosScrollMessage.send(this.containerAccess.getContainerId(), newScrollIndex);
                }
            });
        }

        public int getVisibleSlotCount() {
            return Math.min(this.getCuriosHandler().map(ICuriosItemHandler::getVisibleSlots).orElse(0), this.maxSlotsDisplayed);
        }

        public boolean canScroll() {
            return this.getCuriosHandler().map(itemHandler -> itemHandler.getVisibleSlots() > this.maxSlotsDisplayed).orElse(false);
        }

        private LazyOptional<ICuriosItemHandler> getCuriosHandler() {
            return CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.containerAccess.getPlayer());
        }
    }

    private static class TabContainerAccessDecorator<T extends AbstractElementContainer>
    implements IContainerAccess {
        private final T container;

        public static <T extends AbstractElementContainer> TabContainerAccessDecorator<T> of(T container) {
            return new TabContainerAccessDecorator<T>(container);
        }

        private TabContainerAccessDecorator(T container) {
            this.container = container;
        }

        @Override
        public int getContainerId() {
            return ((AbstractElementContainer)((Object)this.container)).f_38840_;
        }

        @Override
        public void addSlot(Slot slot) {
            ((AbstractElementContainer)((Object)this.container)).m_38897_(slot);
        }

        @Override
        public NonNullList<Slot> getSlots() {
            return ((AbstractElementContainer)((Object)this.container)).f_38839_;
        }

        @Override
        public NonNullList<ItemStack> getLastSlots() {
            return ((AbstractElementContainer)((Object)this.container)).f_38841_;
        }

        @Override
        public NonNullList<ItemStack> getRemoteSlots() {
            return ((AccessorAbstractContainerMenu)this.container).getRemoteSlots();
        }

        @Override
        public Player getPlayer() {
            return ((AbstractElementContainer)((Object)this.container)).getPlayer();
        }

        @Override
        public boolean isClient() {
            return this.getPlayer().f_19853_.f_46443_;
        }
    }

    private static interface IContainerAccess {
        public int getContainerId();

        public void addSlot(Slot var1);

        public NonNullList<Slot> getSlots();

        public NonNullList<ItemStack> getLastSlots();

        public NonNullList<ItemStack> getRemoteSlots();

        public Player getPlayer();

        public boolean isClient();
    }
}

