/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.block.entity.SpiritExtractorTileEntity;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.oversized.OverSizedTabSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSlotIcons;
import iskallia.vault.network.message.SpiritExtractorBuyItemsMessage;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SpiritExtractorContainer
extends OverSizedSlotContainer {
    private final BlockPos pos;
    private final SpiritExtractorTileEntity tileEntity;
    private int lastSpiritRecoveryCount = -1;

    public SpiritExtractorContainer(int id, Inventory playerInventory, BlockPos pos) {
        super(ModContainers.SPIRIT_EXTRACTOR_CONTAINER, id, playerInventory.f_35978_);
        this.pos = pos;
        BlockEntity tile = this.player.f_19853_.m_7702_(pos);
        if (tile instanceof SpiritExtractorTileEntity) {
            SpiritExtractorTileEntity spiritExtractorTile;
            this.tileEntity = spiritExtractorTile = (SpiritExtractorTileEntity)tile;
            this.initSlots(playerInventory);
        } else {
            this.tileEntity = null;
        }
    }

    private void initSlots(Inventory playerInventory) {
        int playerInventoryTopY = 102;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new TabSlot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, playerInventoryTopY + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new TabSlot((Container)playerInventory, hotbarSlot, 8 + hotbarSlot * 18, playerInventoryTopY + 54 + 4));
        }
        OverSizedTabSlot paymentSlot = new OverSizedTabSlot(this.tileEntity.getPaymentInventory(), 0, 90, playerInventoryTopY - 32){

            public boolean m_8010_(Player pPlayer) {
                return !SpiritExtractorContainer.this.tileEntity.isSpewingItems();
            }

            @Override
            public boolean m_5857_(ItemStack stack) {
                return SpiritExtractorContainer.this.getTotalCost().m_41720_() == stack.m_41720_();
            }
        };
        paymentSlot.setBackground(InventoryMenu.f_39692_, ModSlotIcons.COINS_NO_ITEM);
        this.m_38897_(paymentSlot);
    }

    public boolean m_6875_(Player player) {
        return player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) <= 64.0;
    }

    public List<ItemStack> getStoredItems() {
        return this.tileEntity.getItems();
    }

    public void startSpewingItems() {
        this.tileEntity.spewItems();
        if (this.player.f_19853_.m_5776_()) {
            ModNetwork.CHANNEL.sendToServer((Object)new SpiritExtractorBuyItemsMessage(this.getExtractorPos()));
        }
        this.player.m_6915_();
    }

    public boolean coinsCoverTotalCost() {
        return this.tileEntity.coinsCoverTotalCost();
    }

    public BlockPos getExtractorPos() {
        return this.pos;
    }

    public ItemStack getTotalCost() {
        return this.tileEntity.getTotalCost();
    }

    public int getSpiritRecoveryCount() {
        return this.tileEntity.getSpiritRecoveryCount();
    }

    public void m_38946_() {
        ServerLevel serverLevel;
        Level level = this.player.f_19853_;
        if (level instanceof ServerLevel && this.lastSpiritRecoveryCount != this.getLastSpiritRecoveryCount(serverLevel = (ServerLevel)level)) {
            this.updateLastSpiritRecoveryCountOnClient(serverLevel);
        }
        super.m_38946_();
    }

    public void m_182423_() {
        ServerLevel serverLevel;
        Level level = this.player.f_19853_;
        if (level instanceof ServerLevel && this.lastSpiritRecoveryCount != this.getLastSpiritRecoveryCount(serverLevel = (ServerLevel)level)) {
            this.updateLastSpiritRecoveryCountOnClient(serverLevel);
        }
        super.m_182423_();
    }

    private void updateLastSpiritRecoveryCountOnClient(ServerLevel serverLevel) {
        this.tileEntity.recalculateCost();
        serverLevel.m_7260_(this.tileEntity.m_58899_(), this.tileEntity.m_58900_(), this.tileEntity.m_58900_(), 3);
        this.lastSpiritRecoveryCount = this.getLastSpiritRecoveryCount(serverLevel);
    }

    private int getLastSpiritRecoveryCount(ServerLevel serverLevel) {
        return this.tileEntity.getSpiritRecoveryCountFromData(serverLevel);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.m_38903_(slotStack, 36, 37, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= 0 && index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : (index >= 27 && index < 36 ? !this.m_38903_(slotStack, 0, 27, false) : !this.m_38903_(slotStack, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemstack;
    }

    public boolean isSpewingItems() {
        return this.tileEntity.isSpewingItems();
    }
}

