/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.block.entity.BountyTableTileEntity;
import iskallia.vault.bounty.Bounty;
import iskallia.vault.bounty.BountyList;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.oversized.OverSizedTabSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModSlotIcons;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class BountyContainer
extends OverSizedSlotContainer {
    private final BountyList active;
    private final BountyList available;
    private final BountyList complete;
    private final int vaultLevel;
    private final BountyTableTileEntity tileEntity;

    public BountyContainer(int id, Level level, Inventory playerInventory, CompoundTag data) {
        super(ModContainers.BOUNTY_CONTAINER, id, playerInventory.f_35978_);
        if (!data.m_128456_()) {
            this.active = new BountyList(data.m_128469_("active"));
            this.available = new BountyList(data.m_128469_("available"));
            this.complete = new BountyList(data.m_128469_("abandoned"));
        } else {
            this.active = new BountyList();
            this.available = new BountyList();
            this.complete = new BountyList();
        }
        this.vaultLevel = data.m_128451_("vaultLevel");
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("pos"));
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof BountyTableTileEntity) {
            BountyTableTileEntity bountyTableTileEntity;
            this.tileEntity = bountyTableTileEntity = (BountyTableTileEntity)tile;
            this.initSlots(playerInventory);
        } else {
            this.tileEntity = null;
        }
    }

    public Slot getBronzeSlot() {
        return (Slot)this.f_38839_.get(36);
    }

    private void initSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new TabSlot((Container)playerInventory, column + row * 9 + 9, 12 + column * 18, 139 + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new TabSlot((Container)playerInventory, hotbarSlot, 12 + hotbarSlot * 18, 197));
        }
        OverSizedInventory invContainer = this.tileEntity.getInventory();
        this.m_38897_(new OverSizedTabSlot(invContainer, 0, 72, 118).setFilter(stack -> stack.m_150930_((Item)ModBlocks.VAULT_BRONZE)).setBackground(InventoryMenu.f_39692_, ModSlotIcons.COINS_NO_ITEM));
    }

    public BountyList getActive() {
        return this.active;
    }

    public BountyList getAvailable() {
        return this.available;
    }

    public BountyList getComplete() {
        return this.complete;
    }

    public int getVaultLevel() {
        return this.vaultLevel;
    }

    public Optional<Bounty> getBountyById(UUID id) {
        if (this.active.contains(id)) {
            return this.active.findById(id);
        }
        if (this.available.contains(id)) {
            return this.available.findById(id);
        }
        if (this.complete.contains(id)) {
            return this.complete.findById(id);
        }
        return Optional.empty();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.moveOverSizedItemStackTo(slotStack, slot, 36, this.f_38839_.size(), false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.moveOverSizedItemStackTo(slotStack, slot, 27, 36, false) : (index >= 27 && index < 36 ? !this.moveOverSizedItemStackTo(slotStack, slot, 0, 27, false) : !this.moveOverSizedItemStackTo(slotStack, slot, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemstack;
    }

    public boolean m_6875_(@Nonnull Player player) {
        return true;
    }

    public void replaceActive(BountyList list) {
        this.active.clear();
        this.active.addAll(list);
    }

    public void replaceAvailable(BountyList list) {
        this.available.clear();
        this.available.addAll(list);
    }

    public void replaceComplete(BountyList list) {
        this.complete.clear();
        this.complete.addAll(list);
    }

    public BountyTableTileEntity getTileEntity() {
        return this.tileEntity;
    }
}

