/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.gear;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.BooleanFlagGenerator;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.config.DoubleAttributeGenerator;
import iskallia.vault.gear.attribute.config.IntegerAttributeGenerator;
import iskallia.vault.gear.attribute.custom.EffectAvoidanceGearAttribute;
import iskallia.vault.gear.attribute.custom.EffectCloudAttribute;
import iskallia.vault.gear.attribute.custom.EffectGearAttribute;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potions;
import org.apache.commons.lang3.ObjectUtils;

public class VaultGearTierConfig
extends Config {
    private Item gearItem;
    @Expose
    private final Map<VaultGearModifier.AffixType, AttributeGroup> modifierGroup = new LinkedHashMap<VaultGearModifier.AffixType, AttributeGroup>();

    public static Map<Item, VaultGearTierConfig> registerConfigs() {
        HashMap<Item, VaultGearTierConfig> gearConfig = new HashMap<Item, VaultGearTierConfig>();
        List<Item> gearItems = Arrays.asList(ModItems.HELMET, ModItems.CHESTPLATE, ModItems.LEGGINGS, ModItems.BOOTS, ModItems.SWORD, ModItems.AXE, ModItems.SHIELD, ModItems.IDOL_BENEVOLENT, ModItems.IDOL_MALEVOLENCE, ModItems.IDOL_OMNISCIENT, ModItems.IDOL_TIMEKEEPER);
        for (Item item : gearItems) {
            gearConfig.put(item, (VaultGearTierConfig)new VaultGearTierConfig(item).readConfig());
        }
        return gearConfig;
    }

    public static Optional<VaultGearTierConfig> getConfig(Item item) {
        return Optional.ofNullable(ModConfigs.VAULT_GEAR_CONFIG.get(item));
    }

    public VaultGearTierConfig(Item gearItem) {
        this.gearItem = gearItem;
    }

    @Override
    public String getName() {
        return "gear_modifiers%s%s".formatted(File.separator, this.gearItem.getRegistryName().m_135815_());
    }

    @Nullable
    public Object getTierConfig(VaultGearModifier<?> modifier) {
        ResourceLocation modGroup = modifier.getModifierIdentifier();
        int tier = modifier.getRolledTier();
        if (modGroup == null || tier == -1) {
            return null;
        }
        for (AttributeGroup attributePool : this.modifierGroup.values()) {
            if (attributePool.isEmpty()) continue;
            for (ModifierTierGroup group : attributePool) {
                if (!group.identifier.equals((Object)modGroup)) continue;
                if (tier >= group.size()) {
                    return null;
                }
                return ((ModifierTier)group.get(tier)).getModifierConfiguration();
            }
        }
        return null;
    }

    public List<ModifierTier<?>> getAllTiers(@Nullable ResourceLocation identifier) {
        if (identifier == null) {
            return Collections.emptyList();
        }
        for (AttributeGroup attributePool : this.modifierGroup.values()) {
            for (ModifierTierGroup group : attributePool) {
                if (!group.identifier.equals((Object)identifier)) continue;
                return Collections.unmodifiableList(group);
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    public VaultGearModifier<?> generateModifier(ResourceLocation identifier, int level, Random random) {
        for (AttributeGroup attributePool : this.modifierGroup.values()) {
            for (ModifierTierGroup group : attributePool) {
                if (!group.identifier.equals((Object)identifier)) continue;
                WeightedList outcomes = new WeightedList();
                group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new ModifierOutcome(tier, group), tier.getWeight()));
                return outcomes.getRandom().map(modifierOutcome -> modifierOutcome.makeModifier(random)).orElse(null);
            }
        }
        return null;
    }

    @Nullable
    public VaultGearModifier<?> maxAndIncreaseTier(VaultGearModifier.AffixType type, VaultGearModifier<?> modifier, int level, int tierIncrease, Random random) {
        AttributeGroup attributeGroup = this.modifierGroup.get((Object)type);
        if (attributeGroup == null || attributeGroup.isEmpty()) {
            return null;
        }
        ModifierTierGroup tierGroup = null;
        for (ModifierTierGroup configTierGroup : attributeGroup) {
            if (!configTierGroup.identifier.equals((Object)modifier.getModifierIdentifier())) continue;
            tierGroup = configTierGroup;
            break;
        }
        if (tierGroup == null) {
            return null;
        }
        ModifierTier<?> foundTier = tierGroup.getHighestForLevel(level);
        if (foundTier == null) {
            return null;
        }
        int index = Math.min(foundTier.getModifierTier() + tierIncrease, tierGroup.size() - 1);
        return ((ModifierTier)tierGroup.get(index)).makeModifier(tierGroup, random);
    }

    public List<VaultGearModifier<?>> generateImplicits(int level, Random random) {
        AttributeGroup attributePool = this.modifierGroup.get((Object)VaultGearModifier.AffixType.IMPLICIT);
        if (attributePool == null || attributePool.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList modifiers = new ArrayList();
        attributePool.forEach(group -> {
            WeightedList outcomes = new WeightedList();
            group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new ModifierOutcome(tier, (ModifierTierGroup)group), tier.getWeight()));
            outcomes.getRandom(random).map(outcome -> outcome.makeModifier(random)).ifPresent(modifiers::add);
        });
        return modifiers;
    }

    public Optional<VaultGearModifier<?>> getRandomModifier(VaultGearModifier.AffixType type, int level, Random random, Set<String> excludedModGroups) {
        AttributeGroup attributePool = this.modifierGroup.get((Object)type);
        if (attributePool == null || attributePool.isEmpty()) {
            return Optional.empty();
        }
        WeightedList outcomes = new WeightedList();
        attributePool.forEach(group -> {
            if (excludedModGroups.contains(group.modifierGroup)) {
                return;
            }
            group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new ModifierOutcome(tier, (ModifierTierGroup)group), tier.getWeight()));
        });
        return outcomes.getRandom().map(modifierOutcome -> modifierOutcome.makeModifier(random));
    }

    public List<Tuple<VaultGearModifier.AffixType, ModifierTierGroup>> getModifierGroupConfigurations(String modGroup) {
        ArrayList<Tuple<VaultGearModifier.AffixType, ModifierTierGroup>> configs = new ArrayList<Tuple<VaultGearModifier.AffixType, ModifierTierGroup>>();
        for (Map.Entry<VaultGearModifier.AffixType, AttributeGroup> entry : this.modifierGroup.entrySet()) {
            for (ModifierTierGroup group : entry.getValue()) {
                if (!group.modifierGroup.equals(modGroup)) continue;
                configs.add((Tuple<VaultGearModifier.AffixType, ModifierTierGroup>)new Tuple((Object)entry.getKey(), (Object)group));
            }
        }
        return configs;
    }

    @Override
    protected void reset() {
        this.modifierGroup.clear();
        AttributeGroup implicits = new AttributeGroup();
        this.modifierGroup.put(VaultGearModifier.AffixType.IMPLICIT, implicits);
        ModifierTierGroup armorTierGroup = new ModifierTierGroup(ModGearAttributes.ARMOR, "ModArmor", "armor");
        armorTierGroup.add(new ModifierTier<IntegerAttributeGenerator.Range>(0, 10, new IntegerAttributeGenerator.Range(1, 2, 1)));
        armorTierGroup.add(new ModifierTier<IntegerAttributeGenerator.Range>(15, 10, new IntegerAttributeGenerator.Range(1, 2, 1)));
        armorTierGroup.add(new ModifierTier<IntegerAttributeGenerator.Range>(25, 10, new IntegerAttributeGenerator.Range(1, 2, 1)));
        ModifierTierGroup attackDamageTierGroup = new ModifierTierGroup(ModGearAttributes.ATTACK_DAMAGE, "ModAttackDamage", "attackdamage");
        attackDamageTierGroup.add(new ModifierTier<DoubleAttributeGenerator.Range>(0, 20, new DoubleAttributeGenerator.Range(1.0, 1.5)));
        attackDamageTierGroup.add(new ModifierTier<DoubleAttributeGenerator.Range>(10, 18, new DoubleAttributeGenerator.Range(1.6, 2.0)));
        attackDamageTierGroup.add(new ModifierTier<DoubleAttributeGenerator.Range>(20, 15, new DoubleAttributeGenerator.Range(2.1, 2.5)));
        ModifierTierGroup effectAvoidTierGroup = new ModifierTierGroup(ModGearAttributes.EFFECT_AVOIDANCE, "ModPoisonAvoidance", "poisonavoidance");
        effectAvoidTierGroup.add(new ModifierTier<EffectAvoidanceGearAttribute.Config>(0, 10, new EffectAvoidanceGearAttribute.Config(MobEffects.f_19614_, 0.1f, 0.2f)));
        effectAvoidTierGroup.add(new ModifierTier<EffectAvoidanceGearAttribute.Config>(15, 10, new EffectAvoidanceGearAttribute.Config(MobEffects.f_19614_, 0.21f, 0.3f)));
        AttributeGroup prefixes = new AttributeGroup();
        prefixes.add(armorTierGroup);
        prefixes.add(attackDamageTierGroup);
        prefixes.add(effectAvoidTierGroup);
        this.modifierGroup.put(VaultGearModifier.AffixType.PREFIX, prefixes);
        EffectCloudAttribute.CloudConfig config = new EffectCloudAttribute.CloudConfig("Healing", Potions.f_43623_.getRegistryName(), 40, 4.0f, Color.RED.getRGB(), true, 0.05f);
        config.setAdditionalEffect(new EffectCloudAttribute.CloudEffectConfig(MobEffects.f_19601_.getRegistryName(), 20, 0));
        ModifierTierGroup effectCloudGroup = new ModifierTierGroup(ModGearAttributes.EFFECT_CLOUD, "ModRegenCloud", "regencloud");
        effectCloudGroup.add(new ModifierTier<EffectCloudAttribute.CloudConfig>(0, 10, config));
        ModifierTierGroup effectGroup = new ModifierTierGroup(ModGearAttributes.EFFECT, "ModFireEffect", "fireeffect");
        effectGroup.add(new ModifierTier<EffectGearAttribute.Config>(15, 10, new EffectGearAttribute.Config(MobEffects.f_19607_, 0)));
        ModifierTierGroup fireImmunityGroup = new ModifierTierGroup(ModGearAttributes.IS_FIRE_IMMUNE, "ModFireImmunity", "fireimmunity");
        fireImmunityGroup.add(new ModifierTier<BooleanFlagGenerator.BooleanFlag>(0, 10, new BooleanFlagGenerator.BooleanFlag(true)));
        ModifierTierGroup soulboundGroup = new ModifierTierGroup(ModGearAttributes.SOULBOUND, "ModSoulbound", "soulbound");
        soulboundGroup.add(new ModifierTier<BooleanFlagGenerator.BooleanFlag>(0, 10, new BooleanFlagGenerator.BooleanFlag(true)));
        AttributeGroup suffixes = new AttributeGroup();
        suffixes.add(effectCloudGroup);
        suffixes.add(effectGroup);
        suffixes.add(fireImmunityGroup);
        suffixes.add(soulboundGroup);
        this.modifierGroup.put(VaultGearModifier.AffixType.SUFFIX, suffixes);
    }

    @Override
    protected boolean isValid() {
        HashSet<ResourceLocation> foundIdentifiers = new HashSet<ResourceLocation>();
        for (AttributeGroup group : this.modifierGroup.values()) {
            for (ModifierTierGroup tierGroup : group) {
                if (foundIdentifiers.add(tierGroup.identifier)) continue;
                throw new IllegalArgumentException("Invalid Gear configuration (%s) - duplicate identifier found: %s".formatted(this.getName(), tierGroup.identifier.toString()));
            }
        }
        return true;
    }

    @Override
    protected void onLoad(Config oldConfigInstance) {
        super.onLoad(oldConfigInstance);
        if (oldConfigInstance instanceof VaultGearTierConfig) {
            VaultGearTierConfig cfg = (VaultGearTierConfig)oldConfigInstance;
            this.gearItem = cfg.gearItem;
        }
    }

    public static class AttributeGroup
    extends ArrayList<ModifierTierGroup> {

        public static class Serializer
        implements JsonDeserializer<AttributeGroup>,
        JsonSerializer<AttributeGroup> {
            public AttributeGroup deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonArray array = json.getAsJsonArray();
                AttributeGroup attributeGroup = new AttributeGroup();
                array.forEach(tierGroupElement -> {
                    JsonObject tierGroupObject = tierGroupElement.getAsJsonObject();
                    ResourceLocation attributeKey = new ResourceLocation(tierGroupObject.get("attribute").getAsString());
                    VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(attributeKey);
                    if (attribute == null) {
                        throw new JsonParseException("Unknown Modifier %s".formatted(attributeKey));
                    }
                    ResourceLocation identifier = new ResourceLocation(tierGroupObject.get("identifier").getAsString());
                    ModifierTierGroup group = new ModifierTierGroup(attributeKey, tierGroupObject.get("group").getAsString(), identifier);
                    JsonArray groupArray = tierGroupObject.getAsJsonArray("tiers");
                    for (int i = 0; i < groupArray.size(); ++i) {
                        JsonObject tierObject = groupArray.get(i).getAsJsonObject();
                        int minLevel = tierObject.get("minLevel").getAsInt();
                        int maxLevel = tierObject.get("maxLevel").getAsInt();
                        int weight = tierObject.get("weight").getAsInt();
                        ModifierTier tier = new ModifierTier(minLevel, weight);
                        tier.modifierTier = i;
                        tier.maxLevel = maxLevel;
                        Class<?> configClass = attribute.getGenerator().getConfigurationObjectClass();
                        if (configClass != null) {
                            tier.modifierConfiguration = context.deserialize(tierObject.get("value"), configClass);
                        }
                        group.add(tier);
                    }
                    attributeGroup.add(group);
                });
                return attributeGroup;
            }

            public JsonElement serialize(AttributeGroup src, Type typeOfSrc, JsonSerializationContext context) {
                JsonArray array = new JsonArray();
                src.forEach(group -> {
                    VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(group.attribute);
                    if (attribute == null) {
                        return;
                    }
                    JsonObject groupObject = new JsonObject();
                    groupObject.addProperty("attribute", group.attribute.toString());
                    groupObject.addProperty("group", group.modifierGroup);
                    groupObject.addProperty("identifier", group.identifier.toString());
                    JsonArray groupArray = new JsonArray();
                    group.forEach(modifierTier -> {
                        JsonObject tierObject = new JsonObject();
                        tierObject.addProperty("minLevel", (Number)modifierTier.getMinLevel());
                        tierObject.addProperty("maxLevel", (Number)modifierTier.getMaxLevel());
                        tierObject.addProperty("weight", (Number)modifierTier.getWeight());
                        if (attribute.getGenerator().getConfigurationObjectClass() != null) {
                            tierObject.add("value", context.serialize(modifierTier.getModifierConfiguration()));
                        }
                        groupArray.add((JsonElement)tierObject);
                    });
                    groupObject.add("tiers", (JsonElement)groupArray);
                    array.add((JsonElement)groupObject);
                });
                return array;
            }
        }
    }

    public static class ModifierTierGroup
    extends ArrayList<ModifierTier<?>> {
        private final ResourceLocation attribute;
        private final String modifierGroup;
        private final ResourceLocation identifier;

        public ModifierTierGroup(VaultGearAttribute<?> attribute, String modifierGroup, String identifierStr) {
            this(attribute.getRegistryName(), modifierGroup, VaultMod.id(identifierStr));
        }

        public ModifierTierGroup(ResourceLocation attribute, String modifierGroup, ResourceLocation identifier) {
            this.attribute = attribute;
            this.modifierGroup = modifierGroup;
            this.identifier = identifier;
        }

        public List<ModifierTier<?>> getModifiersForLevel(int level) {
            ArrayList list = new ArrayList();
            for (ModifierTier tier : this) {
                if (tier.getMinLevel() > level || tier.getMaxLevel() != -1 && level > tier.getMaxLevel()) continue;
                list.add(tier);
            }
            return list;
        }

        @Nullable
        public ModifierTier<?> getHighestForLevel(int level) {
            ModifierTier highest = null;
            for (ModifierTier tier : this) {
                if (tier.getMinLevel() > level || highest != null && highest.getMinLevel() >= tier.getMinLevel()) continue;
                highest = tier;
            }
            return highest;
        }

        public ResourceLocation getAttribute() {
            return this.attribute;
        }

        public String getModifierGroup() {
            return this.modifierGroup;
        }

        public ResourceLocation getIdentifier() {
            return this.identifier;
        }
    }

    public static class ModifierTier<T> {
        private final int minLevel;
        private int maxLevel = -1;
        private final int weight;
        private int modifierTier = -1;
        private T modifierConfiguration;

        public ModifierTier(int minLevel, int weight) {
            this(minLevel, weight, null);
        }

        public ModifierTier(int minLevel, int weight, T defaultConfig) {
            this.minLevel = minLevel;
            this.weight = weight;
            this.modifierConfiguration = defaultConfig;
        }

        public int getMinLevel() {
            return this.minLevel;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getModifierTier() {
            return this.modifierTier;
        }

        public T getModifierConfiguration() {
            return this.modifierConfiguration;
        }

        public <C> VaultGearModifier<C> makeModifier(ModifierTierGroup tierGroup, Random random) {
            VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(tierGroup.getAttribute());
            ConfigurableAttributeGenerator<?, ?> generator = attribute.getGenerator();
            Object value = generator.generateRandomValue(this.getModifierConfiguration(), random);
            VaultGearModifier modifier = new VaultGearModifier(attribute, value);
            modifier.setRolledTier(this.getModifierTier());
            modifier.setModifierGroup((String)ObjectUtils.firstNonNull((Object[])new String[]{tierGroup.modifierGroup, ""}));
            modifier.setModifierIdentifier(tierGroup.identifier);
            return modifier;
        }
    }

    private record ModifierOutcome<C>(ModifierTier<C> tier, ModifierTierGroup tierGroup) {
        private <T> VaultGearModifier<T> makeModifier(Random random) {
            return this.tier().makeModifier(this.tierGroup(), random);
        }
    }
}

