/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.gear;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.ItemEntry;
import iskallia.vault.gear.crafting.ProficiencyType;
import iskallia.vault.gear.crafting.recipe.TrinketForgeRecipe;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.gear.crafting.recipe.VaultGearForgeRecipe;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.VaultForgeRecipeMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class VaultGearRecipesConfig
extends Config {
    @Expose
    private final List<GearRecipe> gearRecipes = new ArrayList<GearRecipe>();
    @Expose
    private final List<TrinketRecipe> trinketRecipes = new ArrayList<TrinketRecipe>();

    @Override
    public String getName() {
        return "gear%sgear_recipes".formatted(File.separator);
    }

    public List<VaultForgeRecipe> getAllRecipes() {
        ArrayList<VaultForgeRecipe> recipes = new ArrayList<VaultForgeRecipe>();
        this.gearRecipes.forEach(recipe -> recipes.add(recipe.makeRecipe()));
        this.trinketRecipes.forEach(recipe -> recipes.add(recipe.makeRecipe()));
        return recipes;
    }

    @Nullable
    public VaultForgeRecipe getRecipe(ResourceLocation id) {
        for (GearRecipe gearRecipe : this.gearRecipes) {
            if (!id.equals((Object)gearRecipe.id)) continue;
            return gearRecipe.makeRecipe();
        }
        for (TrinketRecipe trinketRecipe : this.trinketRecipes) {
            if (!id.equals((Object)trinketRecipe.id)) continue;
            return trinketRecipe.makeRecipe();
        }
        return null;
    }

    @Override
    protected void reset() {
        this.gearRecipes.clear();
        this.trinketRecipes.clear();
        for (ProficiencyType proficiencyType : ProficiencyType.getCraftableTypes()) {
            ItemStack out = new ItemStack((ItemLike)proficiencyType.getDisplayStack().get().m_41720_());
            this.gearRecipes.add((GearRecipe)new GearRecipe(out, proficiencyType).addInput(new ItemStack((ItemLike)Items.f_42415_, 2)));
        }
        for (TrinketEffect trinketEffect : TrinketEffectRegistry.getOrderedEntries()) {
            this.trinketRecipes.add((TrinketRecipe)new TrinketRecipe(trinketEffect).addInput(new ItemStack((ItemLike)Items.f_42415_, 2)));
        }
    }

    @Override
    public <T extends Config> T readConfig() {
        Object cfg = super.readConfig();
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        if (srv != null) {
            srv.m_6846_().m_11314_().forEach(player -> this.syncTo((VaultGearRecipesConfig)cfg, (ServerPlayer)player));
        }
        return cfg;
    }

    public void syncTo(VaultGearRecipesConfig cfg, ServerPlayer player) {
        ModNetwork.CHANNEL.sendTo((Object)new VaultForgeRecipeMessage(cfg.getAllRecipes()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static class GearRecipe
    extends ForgeRecipe {
        @Expose
        private final ProficiencyType proficiencyType;

        public GearRecipe(ItemStack output, ProficiencyType proficiencyType) {
            super(output);
            this.proficiencyType = proficiencyType;
        }

        @Override
        public VaultForgeRecipe makeRecipe() {
            ItemStack out = this.output.createItemStack();
            List<ItemStack> in = this.inputs.stream().map(ItemEntry::createItemStack).toList();
            return new VaultGearForgeRecipe(this.id, out, in, this.proficiencyType);
        }
    }

    public static class TrinketRecipe
    extends ForgeRecipe {
        @Expose
        private final ResourceLocation trinket;

        public TrinketRecipe(TrinketEffect<?> trinket) {
            super(trinket.getRegistryName(), new ItemStack((ItemLike)ModItems.TRINKET));
            this.trinket = trinket.getRegistryName();
        }

        @Override
        public VaultForgeRecipe makeRecipe() {
            TrinketEffect<?> trinket = TrinketEffectRegistry.getEffect(this.trinket);
            if (trinket == null) {
                throw new IllegalArgumentException("Unknown trinket: " + this.trinket.toString());
            }
            ItemStack out = this.output.createItemStack();
            List<ItemStack> in = this.inputs.stream().map(ItemEntry::createItemStack).toList();
            return new TrinketForgeRecipe(this.id, out, in, trinket);
        }
    }

    public static class ForgeRecipe {
        @Expose
        protected final ResourceLocation id;
        @Expose
        protected final ItemEntry output;
        @Expose
        protected final List<ItemEntry> inputs = new ArrayList<ItemEntry>();

        public ForgeRecipe(ItemStack out) {
            this(out.m_41720_().getRegistryName(), out);
        }

        public ForgeRecipe(ResourceLocation id, ItemStack out) {
            this.id = id;
            this.output = new ItemEntry(out);
        }

        public <T extends ForgeRecipe> T addInput(ItemStack in) {
            this.inputs.add(new ItemEntry(in));
            return (T)this;
        }

        public VaultForgeRecipe makeRecipe() {
            ItemStack out = this.output.createItemStack();
            List<ItemStack> in = this.inputs.stream().map(ItemEntry::createItemStack).toList();
            return new VaultForgeRecipe(this.id, out, in);
        }
    }
}

