/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.gear;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.init.ModGearModifications;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class VaultGearModificationConfig
extends Config {
    @Expose
    private final Map<ResourceLocation, OperationConfig> operationConfiguration = new LinkedHashMap<ResourceLocation, OperationConfig>();

    @Override
    public String getName() {
        return "gear%sgear_modification".formatted(File.separator);
    }

    @Nullable
    public OperationConfig getOperationConfig(GearModification modification) {
        return this.operationConfiguration.get(modification.getRegistryName());
    }

    public int getPotentialUsed(GearModification modification) {
        OperationConfig range = this.getOperationConfig(modification);
        if (range == null) {
            return 0;
        }
        return range.getPotentialUse(rand);
    }

    @Override
    protected void reset() {
        this.operationConfiguration.clear();
        this.set(ModGearModifications.REFORGE_ALL_MODIFIERS, 2, 4, 1.0f, 1.0f);
        this.set(ModGearModifications.ADD_MODIFIER, 4, 7, 1.3f, 1.2f);
        this.set(ModGearModifications.REMOVE_MODIFIER, 4, 7, 1.3f, 1.2f);
        this.set(ModGearModifications.RESET_POTENTIAL, 0, 0, 2.0f, 4.0f);
        this.set(ModGearModifications.REFORGE_REPAIR_SLOTS, 10, 20, 1.3f, 1.6f);
        this.set(ModGearModifications.REFORGE_ALL_IMPLICITS, 3, 7, 1.0f, 1.0f);
        this.set(ModGearModifications.REFORGE_ALL_ADD_TAG, 5, 8, 1.2f, 1.2f);
        this.set(ModGearModifications.REFORGE_RANDOM_TIER, 3, 9, 1.1f, 1.1f);
    }

    private void set(GearModification modification, int pMin, int pMax, float base, float negative) {
        this.operationConfiguration.put(modification.getRegistryName(), new OperationConfig(pMin, pMax, base, negative));
    }

    public static class OperationConfig {
        @Expose
        private int potentialUseMin;
        @Expose
        private int potentialUseMax;
        @Expose
        private float baseCostMultiplier;
        @Expose
        private float negativePotentialCostMultiplier;

        public OperationConfig(int potentialUseMin, int potentialUseMax, float baseCostMultiplier, float negativePotentialCostMultiplier) {
            this.potentialUseMin = potentialUseMin;
            this.potentialUseMax = potentialUseMax;
            this.baseCostMultiplier = baseCostMultiplier;
            this.negativePotentialCostMultiplier = negativePotentialCostMultiplier;
        }

        public int getPotentialUse(Random rand) {
            return Mth.m_144928_((Random)rand, (int)this.potentialUseMin, (int)this.potentialUseMax);
        }

        public float getBaseCostMultiplier() {
            return this.baseCostMultiplier;
        }

        public float getNegativePotentialCostMultiplier() {
            return this.negativePotentialCostMultiplier;
        }
    }
}

