/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.entry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;

public class LevelEntryList<T extends ILevelEntry>
extends ArrayList<T> {
    public static final LevelEntryList<?> EMPTY = new LevelEntryList();

    public static <T extends ILevelEntry> LevelEntryList<T> empty() {
        return EMPTY;
    }

    @SafeVarargs
    public static <T extends ILevelEntry> LevelEntryList<T> of(T ... elements) {
        LevelEntryList<T> list = new LevelEntryList<T>(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    public LevelEntryList() {
    }

    public LevelEntryList(int initialCapacity) {
        super(initialCapacity);
    }

    public Optional<T> getForLevel(int level) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        this.sort(Comparator.comparing(ILevelEntry::getLevel));
        for (int i = 0; i < this.size(); ++i) {
            if (level >= ((ILevelEntry)this.get(i)).getLevel()) continue;
            if (i == 0) {
                return Optional.empty();
            }
            return Optional.of((ILevelEntry)this.get(i - 1));
        }
        return Optional.of((ILevelEntry)this.get(this.size() - 1));
    }

    public static interface ILevelEntry {
        public int getLevel();
    }

    private static class Test {
        private Test() {
        }

        public static void main(String[] args) {
            LevelEntryList list = new LevelEntryList();
            list.add(new TestLevelEntry(10));
            list.add(new TestLevelEntry(5));
            list.add(new TestLevelEntry(1));
            list.add(new TestLevelEntry(20));
            for (int i = 0; i < 25; ++i) {
                System.out.println("For level " + i + ": " + list.getForLevel(i).orElse(null));
            }
            list = new LevelEntryList();
            Optional result = list.getForLevel(10);
            System.out.println(result);
        }

        private record TestLevelEntry(int level) implements ILevelEntry
        {
            @Override
            public int getLevel() {
                return this.level;
            }
        }
    }
}

