/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.adapter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import iskallia.vault.core.util.WeightedList;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.Map;

public class WeightedListAdapter<E>
extends TypeAdapter<WeightedList<E>> {
    private final TypeAdapter<E> elementTypeAdapter;
    private final ObjectConstructor<? extends WeightedList<E>> constructor;

    public WeightedListAdapter(Gson context, Type elementType, TypeAdapter<E> elementTypeAdapter, ObjectConstructor<? extends WeightedList<E>> constructor) {
        this.elementTypeAdapter = new TypeAdapterRuntimeTypeWrapper<E>(context, elementTypeAdapter, elementType);
        this.constructor = constructor;
    }

    public void write(JsonWriter out, WeightedList<E> value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (Map.Entry<E, Integer> e : value.entrySet()) {
            out.beginObject();
            out.name("value");
            this.elementTypeAdapter.write(out, e.getKey());
            out.name("weight");
            out.value((Number)e.getValue());
            out.endObject();
        }
        out.endArray();
    }

    public WeightedList<E> read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        WeightedList collection = (WeightedList)this.constructor.construct();
        in.beginArray();
        while (in.hasNext()) {
            in.beginObject();
            Object instance = null;
            int weight = 1;
            while (in.peek() == JsonToken.NAME) {
                switch (in.nextName()) {
                    case "value": {
                        instance = this.elementTypeAdapter.read(in);
                        break;
                    }
                    case "weight": {
                        weight = in.nextInt();
                    }
                }
            }
            collection.put(instance, weight);
            in.endObject();
        }
        in.endArray();
        return collection;
    }

    private static class TypeAdapterRuntimeTypeWrapper<T>
    extends TypeAdapter<T> {
        private final Gson context;
        private final TypeAdapter<T> delegate;
        private final Type type;

        TypeAdapterRuntimeTypeWrapper(Gson context, TypeAdapter<T> delegate, Type type) {
            this.context = context;
            this.delegate = delegate;
            this.type = type;
        }

        public T read(JsonReader in) throws IOException {
            return (T)this.delegate.read(in);
        }

        public void write(JsonWriter out, T value) throws IOException {
            TypeAdapter<T> chosen = this.delegate;
            Type runtimeType = this.getRuntimeTypeIfMoreSpecific(this.type, value);
            if (runtimeType != this.type) {
                TypeAdapter<T> runtimeTypeAdapter = this.context.getAdapter(TypeToken.get((Type)runtimeType));
                chosen = !(runtimeTypeAdapter instanceof ReflectiveTypeAdapterFactory.Adapter) ? runtimeTypeAdapter : (!(this.delegate instanceof ReflectiveTypeAdapterFactory.Adapter) ? this.delegate : runtimeTypeAdapter);
            }
            chosen.write(out, value);
        }

        private Type getRuntimeTypeIfMoreSpecific(Type type, Object value) {
            if (value != null && (type == Object.class || type instanceof TypeVariable || type instanceof Class)) {
                type = value.getClass();
            }
            return type;
        }
    }

    public static class Factory
    implements TypeAdapterFactory {
        public static final Factory INSTANCE = new Factory();
        private final ConstructorConstructor constructorConstructor = new ConstructorConstructor(Collections.emptyMap());

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Type type = typeToken.getType();
            Class rawType = typeToken.getRawType();
            if (!WeightedList.class.isAssignableFrom(rawType)) {
                return null;
            }
            Type elementType = this.getElementType(type, rawType);
            TypeAdapter elementTypeAdapter = gson.getAdapter(TypeToken.get((Type)elementType));
            ObjectConstructor constructor = this.constructorConstructor.get(typeToken);
            WeightedListAdapter result = new WeightedListAdapter(gson, elementType, elementTypeAdapter, constructor);
            return result;
        }

        public Type getElementType(Type context, Class<?> contextRawType) {
            Type collectionType = this.getSupertype(context, contextRawType, WeightedList.class);
            if (collectionType instanceof WildcardType) {
                collectionType = ((WildcardType)collectionType).getUpperBounds()[0];
            }
            if (collectionType instanceof ParameterizedType) {
                return ((ParameterizedType)collectionType).getActualTypeArguments()[0];
            }
            return Object.class;
        }

        public Type getSupertype(Type context, Class<?> contextRawType, Class<?> supertype) {
            if (context instanceof WildcardType) {
                context = ((WildcardType)context).getUpperBounds()[0];
            }
            .Gson.Preconditions.checkArgument((boolean)supertype.isAssignableFrom(contextRawType));
            return .Gson.Types.resolve((Type)context, contextRawType, (Type)this.getGenericSupertype(context, contextRawType, supertype));
        }

        public Type getGenericSupertype(Type context, Class<?> rawType, Class<?> toResolve) {
            if (toResolve == rawType) {
                return context;
            }
            if (toResolve.isInterface()) {
                Class<?>[] interfaces = rawType.getInterfaces();
                int length = interfaces.length;
                for (int i = 0; i < length; ++i) {
                    if (interfaces[i] == toResolve) {
                        return rawType.getGenericInterfaces()[i];
                    }
                    if (!toResolve.isAssignableFrom(interfaces[i])) continue;
                    return this.getGenericSupertype(rawType.getGenericInterfaces()[i], interfaces[i], toResolve);
                }
            }
            if (!rawType.isInterface()) {
                while (rawType != Object.class) {
                    Class<?> rawSupertype = rawType.getSuperclass();
                    if (rawSupertype == toResolve) {
                        return rawType.getGenericSuperclass();
                    }
                    if (toResolve.isAssignableFrom(rawSupertype)) {
                        return this.getGenericSupertype(rawType.getGenericSuperclass(), rawSupertype, toResolve);
                    }
                    rawType = rawSupertype;
                }
            }
            return toResolve;
        }
    }
}

