/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.world.vault.gen.layout.DiamondRoomLayout;
import iskallia.vault.world.vault.gen.layout.SquareRoomLayout;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;

public class VaultSizeConfig
extends Config {
    @Expose
    private SizeLayout defaultLayout;
    @Expose
    private SizeLayout raffleLayout;
    @Expose
    private final LevelEntryList<Level> levels = new LevelEntryList();

    @Override
    public String getName() {
        return "vault_size";
    }

    @Override
    protected void reset() {
        this.raffleLayout = new SizeLayout(11, 6.0f, DiamondRoomLayout.ID);
        this.defaultLayout = new SizeLayout(11, 6.0f, DiamondRoomLayout.ID);
        this.levels.clear();
        SizeLayout l1 = new SizeLayout(7, 3.0f, DiamondRoomLayout.ID);
        this.levels.add(new Level(0, new WeightedList<SizeLayout>().add(l1, 1)));
        SizeLayout l2 = new SizeLayout(9, 4.5f, DiamondRoomLayout.ID);
        this.levels.add(new Level(25, new WeightedList<SizeLayout>().add(l2, 1)));
        SizeLayout l3 = new SizeLayout(11, 6.0f, DiamondRoomLayout.ID);
        this.levels.add(new Level(50, new WeightedList<SizeLayout>().add(l3, 1)));
        SizeLayout l41 = new SizeLayout(13, 9.0f, DiamondRoomLayout.ID);
        SizeLayout l42 = new SizeLayout(13, 9.0f, SquareRoomLayout.ID);
        this.levels.add(new Level(75, new WeightedList<SizeLayout>().add(l41, 2).add(l42, 1)));
        SizeLayout l51 = new SizeLayout(15, 10.0f, DiamondRoomLayout.ID);
        SizeLayout l52 = new SizeLayout(15, 10.0f, SquareRoomLayout.ID);
        this.levels.add(new Level(100, new WeightedList<SizeLayout>().add(l51, 2).add(l52, 1)));
        SizeLayout l61 = new SizeLayout(17, 10.0f, DiamondRoomLayout.ID);
        SizeLayout l62 = new SizeLayout(15, 12.0f, SquareRoomLayout.ID);
        this.levels.add(new Level(125, new WeightedList<SizeLayout>().add(l61, 2).add(l62, 1)));
        SizeLayout l71 = new SizeLayout(19, 12.0f, DiamondRoomLayout.ID);
        SizeLayout l72 = new SizeLayout(17, 14.5f, SquareRoomLayout.ID);
        this.levels.add(new Level(150, new WeightedList<SizeLayout>().add(l71, 2).add(l72, 1)));
    }

    @Nonnull
    public SizeLayout getLayout(int vaultLevel, boolean isRaffle) {
        if (isRaffle) {
            return this.raffleLayout;
        }
        Optional<Level> levelConfig = this.levels.getForLevel(vaultLevel);
        if (levelConfig.isEmpty()) {
            return this.defaultLayout;
        }
        SizeLayout layout = levelConfig.get().outcomes.getRandom(rand);
        if (layout == null) {
            return this.defaultLayout;
        }
        return layout;
    }

    public static class SizeLayout {
        @Expose
        private final int size;
        @Expose
        private final float objectiveRoomRatio;
        @Expose
        private final String layout;

        public SizeLayout(int size, float objectiveRoomRatio, ResourceLocation layout) {
            this(size, objectiveRoomRatio, layout.toString());
        }

        public SizeLayout(int size, float objectiveRoomRatio, String layout) {
            this.size = size;
            this.objectiveRoomRatio = objectiveRoomRatio;
            this.layout = layout;
        }

        public int getSize() {
            return this.size;
        }

        public float getObjectiveRoomRatio() {
            return this.objectiveRoomRatio;
        }

        public ResourceLocation getLayout() {
            return new ResourceLocation(this.layout);
        }
    }

    public static class Level
    implements LevelEntryList.ILevelEntry {
        @Expose
        private final int level;
        @Expose
        private final WeightedList<SizeLayout> outcomes;

        public Level(int level, WeightedList<SizeLayout> outcomes) {
            this.level = level;
            this.outcomes = outcomes;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

