/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.ChanceItemStackEntry;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.gear.DataTransferItem;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class VaultRecyclerConfig
extends Config {
    @Expose
    private int processingTickTime;
    @Expose
    private final Map<VaultGearRarity, Float> additionalOutputRarityChances = new LinkedHashMap<VaultGearRarity, Float>();
    @Expose
    private RecyclerOutput gearRecyclingOutput;
    @Expose
    private RecyclerOutput trinketRecyclingOutput;

    @Override
    public String getName() {
        return "vault_recycler";
    }

    public int getProcessingTickTime() {
        return this.processingTickTime;
    }

    public RecyclerOutput getGearRecyclingOutput() {
        return this.gearRecyclingOutput;
    }

    public RecyclerOutput getTrinketRecyclingOutput() {
        return this.trinketRecyclingOutput;
    }

    public float getAdditionalOutputRarityChance(VaultGearRarity rarity) {
        return this.additionalOutputRarityChances.getOrDefault((Object)rarity, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    protected void reset() {
        this.processingTickTime = 40;
        this.additionalOutputRarityChances.clear();
        this.additionalOutputRarityChances.put(VaultGearRarity.SCRAPPY, Float.valueOf(0.0f));
        this.additionalOutputRarityChances.put(VaultGearRarity.COMMON, Float.valueOf(0.05f));
        this.additionalOutputRarityChances.put(VaultGearRarity.RARE, Float.valueOf(0.1f));
        this.additionalOutputRarityChances.put(VaultGearRarity.EPIC, Float.valueOf(0.15f));
        this.additionalOutputRarityChances.put(VaultGearRarity.OMEGA, Float.valueOf(0.2f));
        this.gearRecyclingOutput = new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.VAULT_SCRAP), 4, 8, 1.0f), new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.PAINITE_GEM), 1, 1, 0.05f), new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.FACETED_FOCUS), 1, 1, 0.0f));
        this.trinketRecyclingOutput = new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)Items.f_42410_), 1, 1, 1.0f), new ChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f), new ChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f));
    }

    public static class RecyclerOutput {
        @Expose
        private final ChanceItemStackEntry mainOutput;
        @Expose
        private final ChanceItemStackEntry extraOutput1;
        @Expose
        private final ChanceItemStackEntry extraOutput2;

        public RecyclerOutput(ChanceItemStackEntry mainOutput, ChanceItemStackEntry extraOutput1, ChanceItemStackEntry extraOutput2) {
            this.mainOutput = mainOutput;
            this.extraOutput1 = extraOutput1;
            this.extraOutput2 = extraOutput2;
        }

        public ItemStack generateMainOutput() {
            return DataTransferItem.doConvertStack(this.mainOutput.createItemStack(Config.rand));
        }

        public ItemStack getMainOutputMatching() {
            return this.mainOutput.getMatchingStack();
        }

        public ItemStack generateExtraOutput1() {
            return DataTransferItem.doConvertStack(this.extraOutput1.createItemStack(Config.rand));
        }

        public ItemStack getExtraOutput1Matching() {
            return this.extraOutput1.getMatchingStack();
        }

        public ItemStack generateExtraOutput2() {
            return DataTransferItem.doConvertStack(this.extraOutput2.createItemStack(Config.rand));
        }

        public ItemStack getExtraOutput2Matching() {
            return this.extraOutput2.getMatchingStack();
        }
    }
}

