/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.config.entry.SingleItemEntry;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.gear.DataTransferItem;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class VaultMobGearConfig
extends Config {
    @Expose
    private final Map<ResourceLocation, LevelEntryList<EquipmentSet>> MOB_GEAR = new HashMap<ResourceLocation, LevelEntryList<EquipmentSet>>();

    @Override
    public String getName() {
        return "vault_mobs_gear";
    }

    public Optional<EquipmentSet> getEquipment(EntityType<?> entityType, int vaultLevel) {
        return Optional.ofNullable(this.MOB_GEAR.get(entityType.getRegistryName())).flatMap(levelList -> levelList.getForLevel(vaultLevel));
    }

    public static void applyEquipment(LivingEntity entity, int vaultLevel) {
        entity.m_21315_();
        EquipmentSet set = ModConfigs.VAULT_MOBS_GEAR.getEquipment(entity.m_6095_(), vaultLevel).orElse(null);
        if (set == null) {
            Arrays.stream(EquipmentSlot.values()).forEach(slot -> entity.m_8061_(slot, ItemStack.f_41583_));
            return;
        }
        for (EquipmentSlot slot2 : EquipmentSlot.values()) {
            ItemStack equipment = set.getRandomEquipment(slot2).orElse(ItemStack.f_41583_).m_41777_();
            if (equipment.m_41619_()) {
                entity.m_8061_(slot2, ItemStack.f_41583_);
                continue;
            }
            equipment = DataTransferItem.doConvertStack(equipment);
            entity.m_8061_(slot2, equipment);
            if (!(equipment.m_41720_() instanceof VaultGearItem)) continue;
            if (entity instanceof AgeableMob) {
                AgeableMob ageable = (AgeableMob)entity;
                ageable.m_6863_(false);
            }
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            mob.m_6863_(false);
        }
    }

    @Override
    protected void reset() {
        this.MOB_GEAR.clear();
        LevelEntryList equipmentSet = new LevelEntryList();
        EquipmentSet set = new EquipmentSet(0);
        set.slots.put(EquipmentSlot.HEAD.name(), new WeightedList<SingleItemEntry>().add(SingleItemEntry.EMPTY, 20).add(new SingleItemEntry(new ItemStack((ItemLike)Items.f_42472_)), 10));
        set.slots.put(EquipmentSlot.CHEST.name(), new WeightedList());
        set.slots.put(EquipmentSlot.LEGS.name(), new WeightedList());
        set.slots.put(EquipmentSlot.FEET.name(), new WeightedList());
        set.slots.put(EquipmentSlot.MAINHAND.name(), new WeightedList());
        set.slots.put(EquipmentSlot.OFFHAND.name(), new WeightedList());
        equipmentSet.add(set);
        this.MOB_GEAR.put(EntityType.f_20501_.getRegistryName(), equipmentSet);
    }

    public static class EquipmentSet
    implements LevelEntryList.ILevelEntry {
        @Expose
        private int minLevel;
        @Expose
        private Map<String, WeightedList<SingleItemEntry>> slots = new LinkedHashMap<String, WeightedList<SingleItemEntry>>();

        public EquipmentSet(int minLevel) {
            this.minLevel = minLevel;
        }

        @Override
        public int getLevel() {
            return this.minLevel;
        }

        public Optional<ItemStack> getRandomEquipment(EquipmentSlot slot) {
            WeightedList<SingleItemEntry> stackSet = this.slots.get(slot.name());
            if (stackSet == null || stackSet.isEmpty()) {
                return Optional.empty();
            }
            return stackSet.getRandom(Config.rand).map(SingleItemEntry::createItemStack);
        }
    }
}

