/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import java.util.ArrayList;
import java.util.List;

public class VaultLevelsConfig
extends Config {
    @Expose
    private int maxLevel;
    @Expose
    private final List<VaultLevelMeta> levelMetas = new ArrayList<VaultLevelMeta>();

    @Override
    public String getName() {
        return "vault_levels";
    }

    public VaultLevelMeta getLevelMeta(int level) {
        int maxLevelTNLAvailable = this.levelMetas.size() - 1;
        if (level < 0 || level > maxLevelTNLAvailable) {
            return this.levelMetas.get(maxLevelTNLAvailable);
        }
        return this.levelMetas.get(level);
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    protected void reset() {
        this.maxLevel = 100;
        this.levelMetas.clear();
        for (int x = 0; x < this.maxLevel; ++x) {
            VaultLevelMeta vaultLevel = new VaultLevelMeta();
            vaultLevel.level = x;
            if (x < 6) {
                vaultLevel.tnl = 1000 * x + 1000;
            } else if (x < 8) {
                vaultLevel.tnl = 2000 * x - 5000;
            } else if (x < 10) {
                vaultLevel.tnl = 1500 * x - 1000;
            } else if (x < 40) {
                vaultLevel.tnl = 400 * x + 10000;
            } else if (x < 60) {
                vaultLevel.tnl = 1200 * x - 22000;
            } else if (x < 90) {
                vaultLevel.tnl = 2000 * x - 70000;
            } else if (x < 100) {
                vaultLevel.tnl = 54810 * x - 0x499774;
            }
            this.levelMetas.add(vaultLevel);
        }
    }

    public long defaultTNLFunction(int level) {
        return 10000L + 400L * (long)level + Math.round(Math.pow((float)level / 59.0f, 28.0));
    }

    public static class VaultLevelMeta {
        @Expose
        public int level;
        @Expose
        public int tnl;
    }
}

