/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.loot.LootRoll;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.CrystalModifiers;
import iskallia.vault.item.crystal.layout.ClassicCircleCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicInfiniteCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicPolygonCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicSpiralCrystalLayout;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import iskallia.vault.item.crystal.objective.BossCrystalObjective;
import iskallia.vault.item.crystal.objective.CakeCrystalObjective;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.item.crystal.objective.ScavengerCrystalObjective;
import iskallia.vault.item.crystal.theme.CrystalTheme;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Rotation;

public class VaultCrystalConfig
extends Config {
    @Expose
    public ModifierStability MODIFIER_STABILITY;
    @Expose
    public Motes MOTES;
    @Expose
    public Map<ResourceLocation, LevelEntryList<ThemeEntry>> THEMES;
    @Expose
    public LevelEntryList<LayoutEntry> LAYOUTS;
    @Expose
    public LevelEntryList<ObjectiveEntry> OBJECTIVES;
    @Expose
    private Map<ResourceLocation, LevelEntryList<SealEntry>> SEALS;

    @Override
    public String getName() {
        return "vault_crystal";
    }

    public Optional<ResourceLocation> getRandomTheme(ResourceLocation id, int level, RandomSource random) {
        return this.THEMES.getOrDefault(id, LevelEntryList.empty()).getForLevel(level).flatMap(entry -> entry.pool.getRandom(random));
    }

    public Optional<CrystalLayout> getRandomLayout(int level, RandomSource random) {
        return this.LAYOUTS.getForLevel(level).flatMap(entry -> entry.pool.getRandom(random));
    }

    public Optional<CrystalObjective> getRandomObjective(int level, RandomSource random) {
        return this.OBJECTIVES.getForLevel(level).flatMap(entry -> entry.pool.getRandom(random));
    }

    public boolean applySeal(Item seal, Item input, CrystalData crystal) {
        if (!this.SEALS.containsKey(seal.getRegistryName())) {
            return false;
        }
        return this.SEALS.get(seal.getRegistryName()).getForLevel(crystal.getLevel()).map(entry -> {
            if (!entry.input.contains(input.getRegistryName())) {
                return false;
            }
            crystal.setObjective(entry.objective);
            if (entry.layout != null) {
                crystal.setLayout(entry.layout);
            }
            if (entry.theme != null) {
                crystal.setTheme(entry.theme);
            }
            if (entry.modifiers != null) {
                crystal.setModifiers(entry.modifiers);
            }
            if (entry.preventsRandomModifiers != null) {
                crystal.setPreventsRandomModifiers(entry.preventsRandomModifiers);
            }
            if (entry.canBeModified != null) {
                crystal.setModifiable(entry.canBeModified);
            }
            return true;
        }).orElse(false);
    }

    @Override
    protected void reset() {
        this.MODIFIER_STABILITY = new ModifierStability();
        this.MOTES = new Motes();
        this.THEMES = new LinkedHashMap<ResourceLocation, LevelEntryList<ThemeEntry>>();
        LevelEntryList defaultTheme = new LevelEntryList();
        defaultTheme.add(new ThemeEntry(0, new WeightedList<ResourceLocation>().add(VaultMod.id("classic_vault_ice"), 1).add(VaultMod.id("classic_vault_cave"), 1)));
        this.THEMES.put(VaultMod.id("default"), defaultTheme);
        LevelEntryList diyTheme = new LevelEntryList();
        defaultTheme.add(new ThemeEntry(0, new WeightedList<ResourceLocation>().add(VaultMod.id("diy_vault_ice"), 1).add(VaultMod.id("diy_vault_cave"), 1)));
        this.THEMES.put(VaultMod.id("diy"), defaultTheme);
        this.LAYOUTS = new LevelEntryList();
        this.LAYOUTS.add(new LayoutEntry(0, new WeightedList<ClassicCircleCrystalLayout>().add(new ClassicCircleCrystalLayout(1, 4), 1).add((ClassicCircleCrystalLayout)((Object)new ClassicSpiralCrystalLayout(1, 4, Rotation.CLOCKWISE_90)), 1).add((ClassicCircleCrystalLayout)new ClassicInfiniteCrystalLayout(0), 1).add((ClassicCircleCrystalLayout)((Object)new ClassicPolygonCrystalLayout(1, new int[]{-4, 4, 4, 4, 4, -4, -4, -4})), 1).add((ClassicCircleCrystalLayout)((Object)new ClassicPolygonCrystalLayout(1, new int[]{-4, 0, 0, 4, 4, 0, 0, -4})), 1)));
        this.OBJECTIVES = new LevelEntryList();
        this.OBJECTIVES.add(new ObjectiveEntry(0, new WeightedList<BossCrystalObjective>().add(new BossCrystalObjective(LootRoll.ofUniform(3, 6), 0.1f), 1).add((BossCrystalObjective)((Object)new ScavengerCrystalObjective(0.1f)), 1)));
        this.SEALS = new LinkedHashMap<ResourceLocation, LevelEntryList<SealEntry>>();
        LevelEntryList list = new LevelEntryList();
        this.SEALS.put(ModItems.CRYSTAL_SEAL_EXECUTIONER.getRegistryName(), list);
        list.add(new SealEntry(0, Arrays.asList(ModItems.VAULT_CRYSTAL.getRegistryName()), new BossCrystalObjective(LootRoll.ofUniform(3, 6), 0.1f), new ClassicInfiniteCrystalLayout(1), null, null, null, null));
        list = new LevelEntryList();
        this.SEALS.put(ModItems.CRYSTAL_SEAL_HUNTER.getRegistryName(), list);
        list.add(new SealEntry(0, Arrays.asList(ModItems.VAULT_CRYSTAL.getRegistryName()), new ScavengerCrystalObjective(0.1f), new ClassicCircleCrystalLayout(1, 5), null, null, null, null));
        list = new LevelEntryList();
        this.SEALS.put(ModItems.CRYSTAL_SEAL_ANCIENTS.getRegistryName(), list);
        list.add(new SealEntry(0, Arrays.asList(ModItems.VAULT_CRYSTAL.getRegistryName()), new CakeCrystalObjective(LootRoll.ofUniform(10, 15)), new ClassicSpiralCrystalLayout(1, 99, Rotation.CLOCKWISE_90), null, null, null, null));
    }

    public static class ModifierStability {
        @Expose
        public int craftsBeforeInstability = 5;
        @Expose
        public float instabilityPerCraft = 0.1f;
        @Expose
        public float instabilityCap = 0.9f;
        @Expose
        public float curseInstabilityThreshold = 0.5f;
        @Expose
        public float curseChanceMin = 0.25f;
        @Expose
        public float curseChanceMax = 0.5f;
        @Expose
        public TextColor curseColor = TextColor.m_131268_((String)"#9C6E3B");

        public float calculateCurseChance(int instability) {
            float instabilityPercentage = (float)instability / 100.0f;
            if (instabilityPercentage < this.curseInstabilityThreshold) {
                return 0.0f;
            }
            float t = (instabilityPercentage - this.curseInstabilityThreshold) / (1.0f - this.curseInstabilityThreshold);
            return this.curseChanceMin + (this.curseChanceMax - this.curseChanceMin) * t;
        }
    }

    public static class Motes {
        @Expose
        public int clarityLevelCost = 1;
        @Expose
        public int purityLevelCost = 2;
        @Expose
        public int sanctityLevelCost = 4;
    }

    private static class ThemeEntry
    implements LevelEntryList.ILevelEntry {
        @Expose
        public int minLevel;
        @Expose
        public WeightedList<ResourceLocation> pool;

        public ThemeEntry(int minLevel, WeightedList<ResourceLocation> pool) {
            this.minLevel = minLevel;
            this.pool = pool;
        }

        @Override
        public int getLevel() {
            return this.minLevel;
        }
    }

    private static class LayoutEntry
    implements LevelEntryList.ILevelEntry {
        @Expose
        public int minLevel;
        @Expose
        public WeightedList<CrystalLayout> pool;

        public LayoutEntry(int minLevel, WeightedList<CrystalLayout> pool) {
            this.minLevel = minLevel;
            this.pool = pool;
        }

        @Override
        public int getLevel() {
            return this.minLevel;
        }
    }

    private static class ObjectiveEntry
    implements LevelEntryList.ILevelEntry {
        @Expose
        public int minLevel;
        @Expose
        public WeightedList<CrystalObjective> pool;

        public ObjectiveEntry(int minLevel, WeightedList<CrystalObjective> pool) {
            this.minLevel = minLevel;
            this.pool = pool;
        }

        @Override
        public int getLevel() {
            return this.minLevel;
        }
    }

    public static class SealEntry
    implements LevelEntryList.ILevelEntry {
        @Expose
        private final int level;
        @Expose
        private final List<ResourceLocation> input;
        @Expose
        private final CrystalObjective objective;
        @Expose
        private final CrystalLayout layout;
        @Expose
        private final CrystalTheme theme;
        @Expose
        private final CrystalModifiers modifiers;
        @Expose
        private final Boolean preventsRandomModifiers;
        @Expose
        private final Boolean canBeModified;

        public SealEntry(int level, List<ResourceLocation> input, CrystalObjective objective, CrystalLayout layout, CrystalTheme theme, CrystalModifiers modifiers, Boolean preventsRandomModifiers, Boolean canBeModified) {
            this.level = level;
            this.input = input;
            this.objective = objective;
            this.layout = layout;
            this.theme = theme;
            this.modifiers = modifiers;
            this.preventsRandomModifiers = preventsRandomModifiers;
            this.canBeModified = canBeModified;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

